/**
 * @author Trupti.Paoneker
 
 * This component is used for to show service master grid details.
 */
Ext.define('Academia.view.othermasters.servicemaster.ServiceMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.servicemastergrid',
    store: 'othermasters.servicemaster.ServiceMasterStore',
    title: getCommonTranslation('SERVICEMASTER_LIST'), //ServiceMaster
    collapsible: false,
    border: true,
    //autoScroll: true,
    headerFix:{
	    headerFix: true,
	    portalIdsWithStructure: {
	    	'servicemaster':1
	    }
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('SERVICE_CODE'), //Service Code	
        dataIndex: 'serviceCode',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('SERVICE_NAME'), //Service Name
        dataIndex: 'serviceName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('SERVICE_DESCRIPTION'), //Service Description
        dataIndex: 'serviceDescription',
        sortable: false,
        flex: .2

    }, {
        header: getCommonTranslation('STATUS'), //Active
        dataIndex: 'active',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (value) {
                return getCommonTranslation('ACTIVE');
            } else {
                return getCommonTranslation('INACTIVE');
            }
        }
    },{
        header: getCommonTranslation('SERVICE_COORDINATOR'), 
        dataIndex: 'serviceStaff',
        sortable: false,
        flex: .2,
        renderer: function(value,meta,record) {
        	if(!isNullOrEmpty(value) && (value.length>0)){
        		return '<a href="#">' +value.length+ '</a>';
        	}else{
    			return '-';
    		}
        }
    },{
    	header: getExaminationTranslation('MAPPED_PROGRAMS'),
        dataIndex: 'serviceLocation',
        sortable: false,
        flex: .2,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.serviceLocation) && record.data.serviceLocation>0){
				return '<a href=#>'+record.data.serviceLocation+'</a>';
			} else {
				return '-';
			}
		}
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add Service
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit Service
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View Service
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnApplyTo',
        tooltip: getExaminationTranslation('APPLY_TO'),
        text: getExaminationTranslation('APPLY_TO')
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.servicemaster.ServiceMasterStore',
            emptyMsg: '<span id="manageAccountingGridId" style="margin-top: 60px !important">'+getCommonTranslation('NO_SERVICE_MASTER_TO_DISPLAY')+'</span>', //No service master  to display
            displayInfo: true
        }]
    }]
});