Ext.define('Academia.view.personinfo.common.PersonDetailsLinkPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.persondetailslinkpanel',
    collapsible: true,
    autoScroll: true,
    border: true,
    bodyCls: 'persondetailslinkpanelFont widthIssueForScroll',
    defaults: {
        bodyStyle: 'padding:5px',
        autoScroll: true,
        minHeight: 170
    },
    layout: {
        type: 'accordion',
        titleCollapse: true,
        animate: true,
        fill: true
    },
    initComponent: function() {
        var this$ = this;
        var items = this$.getPersonLinkPanel();
        this$.items = items;
        this$.callParent(arguments);
    },

    getPersonLinkPanel: function() {
        var this$ = this;
        var panelArray = new Array();
        if (this$.personType === 'CREATE_FACULTY') {
            personInfo = this$.getCreateFacultyProfileLink();
        }else if (this$.personType === 'FACULTY') {
            personInfo = this$.getFacultyProfileLink();
        }else if (this$.personType === 'APPLICANT') {
            personInfo = this$.getApplicantProfileLink();
        }else if (this$.personType === 'OTHER_EMPLOYEE') {
            personInfo = this$.getOtherEmployeeProfileLink();
        } else {
            personInfo = this$.getStudentProfileLink();
        }
        for (var key in personInfo) {
            var personDetailsObj = personInfo[key];
            var personDetailsPanel = Ext.create('Ext.panel.Panel', {
                title: getPersonModuleTranslation(key),
                itemId: key,
                floatable: true,
                layout: {
                    type: 'vbox'
                },
                bodyStyle: {
                    padding: '10px'
                }
            });
            this$.getPersonDetailsLink(personDetailsPanel, personDetailsObj);

            panelArray.push(personDetailsPanel);

        }

        return panelArray;
    },
    getPersonDetailsLink: function(personDetailsPanel, personDetailsObj) {
        var store = Ext.create('Ext.data.Store', {
            extend: 'Ext.data.Store',
            fields: ['tabPanelItemId', 'tabPanelTitle', 'tabPanelItemXtype', 'xtypeItemId', 'isMandatoryTab', 'defaultPanel', 'render', 'afterrender'],
            data: personDetailsObj
        });
        
        var afterrenderFlag = false;
        if(!isNullOrEmpty(store.findRecord('afterrender', "dvRendered"))) {
        	afterrenderFlag = true;
        }

        var personDetailsLink = Ext.create('Ext.view.View', {
            store: store,
            tpl: new Ext.XTemplate( '<tpl for="."><div style="cursor: pointer;" class="thumb-wrap1 personDetailLinkheightCLS">{tabPanelTitle:this.formatChange}'+'<tpl if="isMandatoryTab == true"><span style="color:red;">*</span></tpl>'+'</div></tpl>', {
                formatChange: function(inputValue) {
                    return getPersonModuleTranslation(inputValue);
                }
            }),
            itemSelector: 'div.thumb-wrap1',
            width: '100%',
            listeners: {
            	afterrender: !afterrenderFlag ? Ext.emptyFn : function(dv) {
            		setTimeout(function(){
            			var searchCombo = Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0];
            			var contentPanelActiveTab = dv.up('contentpanel').getActiveTab();
            			if(contentPanelActiveTab.isSubtabRequired){
            				dv.up('panel').expand();            				
            				var store = searchCombo ? searchCombo.store : null;
            		        var index = store ? store.findExact('tabPanelItemXtype', contentPanelActiveTab.subtabXtype) : -1;
            		        var result = index !== -1 ? store.getAt(index) : null;
                			//var result = searchCombo.store.getAt(searchCombo.store.findExact('tabPanelItemXtype',contentPanelActiveTab.subtabXtype));
                			//Ext.query('#'+result.parentPanelSelector)[0].querySelectorAll(result.currentElementSelector)[result.currentItemIndex].click();                			
                			if(result){
                				Ext.defer(function(){
                    				var nodeIndex = dv.getStore().find('tabPanelItemXtype', result.get('tabPanelItemXtype'));
                        			if(nodeIndex != -1){
                            			var dataViewEl = dv.getEl();
                            			//Ext.defer(function() {
                            				var childNodes = dataViewEl.dom.childNodes;
                            				var specificNode = childNodes[nodeIndex];
                            				if(!isNullOrEmpty(specificNode)){                    					
                            					specificNode.click();
                            				}
                            			//}, 1000);
                        			}
                    			},2000)
                			}
            			}
            		}, 1500);
            	}
            }
        });

        personDetailsPanel.add(personDetailsLink);
    },

    getStudentProfileLink: function() {
        var studentProfileLink = {
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: 'STUDENT_PERSONAL_DETAILS',
                tabPanelItemId: 'studentPersonalDetails',
                tabPanelItemXtype: 'personalinformationform',
                xtypeItemId: 'studentPersonalInformationForm',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADDRESSES',
                tabPanelItemId: 'studentAddressDetails',
                tabPanelItemXtype: 'addressdetails',
                xtypeItemId: 'studentAddressTemplate',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'PARENTS_GUARDIANS',
                tabPanelItemId: 'studentParentGuardianDetails',
                tabPanelItemXtype: 'parentguardiangrid',
                xtypeItemId: 'studentParentGuardianGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'FEE_PAYERS',
                tabPanelItemId: 'studentFeePayerDetail',
                tabPanelItemXtype: 'feepayerdetailgrid',
                xtypeItemId: 'studentFeePayerDetailGridItemId',
                render: true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'SIBLING',
                tabPanelItemId: 'studentSiblingDetails',
                tabPanelItemXtype: 'siblingdetailsgrid',
                xtypeItemId: 'studentSiblingDetailsGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'IDENTITY_DETAILS',
                tabPanelItemId: 'studentIdentityDetails',
                tabPanelItemXtype: 'identitydetailsgrid',
                xtypeItemId: 'studentIdentityDetailsGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'OTHER_INFORMATION',
                tabPanelItemId: 'studentOtherInformationDetails',
                tabPanelItemXtype: 'otherinformationdetailsform',
                xtypeItemId: 'studentOtherinformationDetailsForm',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'SSO_DETAILS',
                tabPanelItemId: 'studentssodetailsgrid',
                tabPanelItemXtype: 'ssodetailsgrid',
                xtypeItemId: 'studentssodetailsgridItemId',
                render : true,
                defaultPanel: true
            },
            {
                tabPanelTitle: 'BANK_DETAILS',
                tabPanelItemId: 'studentBankDetails',
                tabPanelItemXtype: 'studentbankdetailsgrid', 
                xtypeItemId: 'studentBankDetailsGridItemId',
                render : true,
                defaultPanel: true 
            },
            
            
            {
                tabPanelTitle: 'LIVING_ARRANGEMENT',
                tabPanelItemId: 'studentLivingArrangementDetails',
                tabPanelItemXtype: 'livingarrangementgrid',
                xtypeItemId: 'studentLivingArrangementGridItemId',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'PASSPORT',
                tabPanelItemId: 'studentPassportGridId',
                tabPanelItemXtype: 'passportgrid',
                xtypeItemId: 'studentPassportGrid',
                render : true,
                defaultPanel: true
            }, {
            	tabPanelTitle: 'VISA',
                tabPanelItemId: 'studentVisaGridId',
                tabPanelItemXtype: 'visadetailgrid',
                xtypeItemId: 'studentVisaGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'PERMIT',
                tabPanelItemId: 'studentPermitGridId',
                tabPanelItemXtype: 'permitgrid',
                xtypeItemId: 'studentPermitGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'INSURANCE',
                tabPanelItemId: 'studentInsuranceGridId',
                tabPanelItemXtype: 'studentinsurancedetailsgrid',
                xtypeItemId: 'studentInsuranceDetailsGrid',
                render : true,
                defaultPanel: true
            }],
            'PAST_HISTORY': [{
                tabPanelTitle: 'EDUCATION',
                tabPanelItemId: 'studentEducationHistoryDetails',
                tabPanelItemXtype: 'educationhistorygrid',
                xtypeItemId: 'studentEducationHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'WORK_EXPERIENCE',
                tabPanelItemId: 'studentWorkExperienceDetails',
                tabPanelItemXtype: 'workexperiencegrid',
                xtypeItemId: 'studentWorkExperienceGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'MEDICAL_HISTORY',
                tabPanelItemId: 'studentMedicalHistory',
                tabPanelItemXtype: 'medicalgrid',
                xtypeItemId: 'studentMedicalGrid',
                render: true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'VACCINATION',
                tabPanelItemId: 'studentVaccinationDetails',
                tabPanelItemXtype: 'vaccinationgrid',
                xtypeItemId: 'studentVaccinationGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'EXTRA_CURRICULUM',
                tabPanelItemId: 'studentExtraCurricularDetails',
                tabPanelItemXtype: 'extracurriculargrid',
                xtypeItemId: 'studentExtraCurricularGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'INFIRMARY_DETAILS',
                tabPanelItemId: 'studentInfirmaryDetails',
                tabPanelItemXtype: 'manageentriesforstudentprofile',
                xtypeItemId: 'studentInfirmaryManageEntriesGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PHYSICAL_CHARACTERISTICS',
                tabPanelItemId: 'studentPhysicalCharacteristicsDetails',
                tabPanelItemXtype: 'physicalcharacteristicsgrid',
                xtypeItemId: 'studentPhysicalCharacteristicsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'RESEARCH_TYPE',
                tabPanelItemId: 'studentResearchTypeDetails',
                tabPanelItemXtype: 'researchtypegrid',
                xtypeItemId: 'studentResearchTypeGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'SEMINAR_DETAILS',
                tabPanelItemId: 'studenntSeminarDetails',
                tabPanelItemXtype: 'seminardetailsgrid',
                xtypeItemId: 'studentSeminarDetailsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PATENT_DETAILS',
                tabPanelItemId: 'studenntPatentDetails',
                tabPanelItemXtype: 'patentdetailsgrid',
                xtypeItemId: 'studentPatentDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'TRAINING_DETAILS',
                tabPanelItemId: 'studentTrainingPersonDetailsgrid',
                tabPanelItemXtype: 'trainingpersondetailsgrid',
                xtypeItemId: 'studentTrainingPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'HOSTEL_DETAILS',
                tabPanelItemId: 'studentHostelPersonDetails',
                tabPanelItemXtype: 'hostelpersondetailsgrid',
                xtypeItemId: 'studentHostelPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'TRANSPORT_DETAILS',
                tabPanelItemId: 'studentTransportPersonDetails',
                tabPanelItemXtype: 'transportpersondetailsgrid',
                xtypeItemId: 'studentTransportPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'COMPETITIVE_EXAM',
            	tabPanelItemId: 'studentCompetitiveExamDetails',
            	tabPanelItemXtype: 'competitiveexamgrid',
            	xtypeItemId: 'studentCompetitiveExamGrid',
            	render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'MD_MEDICAL_DETAILS',
                tabPanelItemId: 'studentMedicalDetails',
                tabPanelItemXtype: 'medicaldetailsform',
                xtypeItemId: 'studentMedicalDetailsFormItemId',
                render: true,
                defaultPanel: true
            },{
                tabPanelTitle: 'CHURCH_INFORMATION_DETAILS',
                tabPanelItemId: 'studentChurchInformationDetails',
                tabPanelItemXtype: 'churchinformationgrid',
                xtypeItemId: 'studentChurchInformationGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'COMMUNICATION_HISTORY',
                tabPanelItemId: 'communicationhistoryDetails',
                tabPanelItemXtype: 'communicationhistorystructure',
                xtypeItemId: 'studentcommunicationhistorystructureItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'NON_ACADEMIC_ACHIEVEMENTS',
                tabPanelItemId: 'studentnonAcademicAchievementsgrid',
                tabPanelItemXtype: 'nonacademicachievementsgrid',
                xtypeItemId: 'studentnonacademicachievementsgridItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'SOCIO_ECONOMIC_INFORMATION',
                tabPanelItemId: 'studentSocioEconomicInformation',
                tabPanelItemXtype: 'socioeconomicinformationform',
                xtypeItemId: 'admStudentSocioEconomicFormItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'POST_SCHOOL_STUDIES',
                tabPanelItemId: 'studentPostSchoolStudies',
                tabPanelItemXtype: 'postschoolstudiesgrid',
                xtypeItemId: 'studentPostSchoolStudiesGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'EDUCATION_DETAILS',
                tabPanelItemId: 'studentEducationHistoryDetailGridId',
                tabPanelItemXtype: 'studenteducationhistorydetailgrid',
                xtypeItemId: 'studentEducationHistoryDetailGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'LANGUAGE_INFORMATION',
                tabPanelItemId: 'studentLanguagesInformation',
                tabPanelItemXtype: 'studentlanguageinformationgrid',
                xtypeItemId: 'studentLanguagesInformationGridItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'HEALTH_INFORMATION',
                tabPanelItemId: 'studentHealthInformation',
                tabPanelItemXtype: 'healthinformationdetailgrid',
                xtypeItemId: 'studentHealthInformationGridItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'STUDENT_ENGAGEMENT',
                tabPanelItemId: 'studentEngagementId',
                tabPanelItemXtype: 'studentengagementform',
                xtypeItemId: 'studentengagementformId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'LEARNING_ALLOWANCE',
                tabPanelItemId: 'learningAllowance',
                tabPanelItemXtype: 'learningallowancegrid',
                xtypeItemId: 'learningAllowanceItemId',
                render : true,
                defaultPanel: true
            }
            ],

            'COURSE_EXECUTION': [{
                tabPanelTitle: 'SCHEDULE',
                tabPanelItemId: 'studentScheduleDetails',
                tabPanelItemXtype: 'scheduledetails',
                xtypeItemId: 'studentScheduleCalender',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'ATTENDANCE',
                tabPanelItemId: 'studentAttendanceDetailsTab',
                tabPanelItemXtype: 'studentattendancereportstructure',
                //tabPanelItemXtype: 'attendancedetails',
                xtypeItemId: 'studentAttendanceDetails',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'BIOMETRIC_MACHINE_DETAILS',
                tabPanelItemId: 'studentbmimachinedetailsTab',
                tabPanelItemXtype: 'studentbmimachinedetailsstructure',
                //tabPanelItemXtype: 'attendancedetails',
                xtypeItemId: 'studentbmimachinedetailsstructureItemId',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'MY_COURSE',
                tabPanelItemId: 'studentMyCourseDetailsTab',
                tabPanelItemXtype: 'mycoursedetails',
                xtypeItemId: 'studentMyCourseDetails',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'PROGRAM_DETAILS',
                tabPanelItemId: 'studentProgramDetailsTab',
                tabPanelItemXtype: 'studentprogramdetailsgrid',
                xtypeItemId: 'studentprogramdetails',
                render : true,
                defaultPanel: true
            }, /*{
                tabPanelTitle: 'PERFORMANCE_TRACKER',
                tabPanelItemId: 'studentPerformanceTrackerDetails',
                tabPanelItemXtype: 'performancetrackerform',
                xtypeItemId: 'performanceTrackerForm',
                render : true,
                defaultPanel: true
            }*/ {
                tabPanelTitle: 'EXAM_ELIGIBILITY',
                tabPanelItemId: 'examEligibility',
                tabPanelItemXtype: 'exameligibiltystportalandprofilestructure',
                xtypeItemId: 'exameligibiltystportalandprofile',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'VIEW_EXAMINATION',
                tabPanelItemId: 'viewExamination',
                tabPanelItemXtype: 'viewexaminationstructureforstportal',
                xtypeItemId: 'viewexaminationstructureforstportal',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'VIEW_ACADEMIC_HISTORY',
                tabPanelItemId: 'viewAcademicHistory',
                tabPanelItemXtype: 'studentacademicshistorystructure',
                xtypeItemId: 'studentacademicshistorystructure',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'ACADEMICS_TOPIC',
                tabPanelItemId: 'academicsTopic',
                tabPanelItemXtype: 'academicstopicsstructureforstudentprofile',
                xtypeItemId: 'academicstopicsstructureforstudentprofile',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'STUDENT_JOURNEY',
                tabPanelItemId: 'studentJourney',
                tabPanelItemXtype: 'studentjourneystructureforcoreerp',
                xtypeItemId: 'studentjourneystructureforcoreerp',
                afterrender: 'dvRendered',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'CONDITIONS_FOR_ADMISSION',
                tabPanelItemId: 'studentconditionsForAdmission',
                tabPanelItemXtype: 'studentconditionsforadmission',
                xtypeItemId: 'studentconditionsforadmissionFormId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PROGRAM_WISE_CONDITIONS_FOR_ADMISSION',
                tabPanelItemId: 'studentProgramWiseConditionsForAdmission',
                tabPanelItemXtype: 'studentprogramwiseconditionsforadmission',
                xtypeItemId: 'studentProgramWiseConditionsforAdmissionFormId',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'DEGREE_AUDIT_REPORT',
                tabPanelItemId: 'degreeAuditReportProfileView',
                tabPanelItemXtype: 'degreeauditreportprofileview',
                xtypeItemId: 'degreeAuditReportSearchForm',
                render : true,
                defaultPanel: true
            	
            },{
                tabPanelTitle: 'SALESFORCE_ADMISSION_DETAILS',
                tabPanelItemId: 'studentsalesforceadmissiondetailsgrid',
                tabPanelItemXtype: 'studentsalesforceadmissiondetailsgrid',
                xtypeItemId: 'studentsalesforceadmissiondetailsgridId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'STUDENT_PROGRAM_COMPLETION_DETAILS',
                tabPanelItemId: 'studentprogramcompletiondetailsgrid',
                tabPanelItemXtype: 'studentprogramcompletiondetailsgrid',
                xtypeItemId: 'studentprogramcompletiondetailsgridId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'STUDENT_TRANSFER_CREDIT',
                tabPanelItemId: 'studenttransfercreditrequeststructure',
                tabPanelItemXtype: 'studenttransfercreditrequeststructure',
                xtypeItemId: 'studenttransfercreditdetailId',
                render : true,
                defaultPanel: true
            }],
            'FLAG_LIST':[{
            	tabPanelTitle: 'RAISED_FLAG_LIST',
            	tabPanelItemId: 'flagliststudentgrid',
            	tabPanelItemXtype: 'flagliststudentgrid',
            	xtypeItemId: 'flagliststudentgridId',
            	render : true,
            	defaultPanel: true
            }],

            'REQUESTS': [{
                tabPanelTitle: 'REQUEST_RAISED_HISTORY',
                tabPanelItemId: 'studentRequestRaisedHistoryDetails',
                tabPanelItemXtype: 'requestraisedhistorygrid',
                xtypeItemId: 'studentRequestRaisedHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REQUEST_PENDING_DESCISION',
                tabPanelItemId: 'studentRequestPendingDecisionDetails',
                tabPanelItemXtype: 'requestpendingdecisiongrid',
                xtypeItemId: 'studentRequestPendingDecisionGrid',
                render : true,
                defaultPanel: true
            }],

            'PAYMENT_REFUND_HISTORY': [/*{
                tabPanelTitle: 'FEE_PLANS',
                tabPanelItemId: 'studentFeePlanDetails',
                tabPanelItemXtype: 'feeplangrid',
                xtypeItemId: 'studentFeePlanGrid',
                render : true,
                defaultPanel: true
            }, */{
                //tabPanelTitle: 'PENDING_BILLS',
                tabPanelTitle: 'BILLS',
                tabPanelItemId: 'studentPendingBillDetails',
                tabPanelItemXtype: 'debitnoteandcreditnotepanel',
                xtypeItemId: 'studentPendingBillsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'HEAD_WISE_BILLS',
                tabPanelItemId: 'studentHeadWiseBillDetails',
                tabPanelItemXtype: 'headwisebillsgrid',
                xtypeItemId: 'studentHeadWiseBillsGrid',
                render : true,
                defaultPanel: true
            }, {
                //tabPanelTitle: 'PAYMENT_RECIEVED',
            	 tabPanelTitle: 'RECEIPTS',
                tabPanelItemId: 'studentPaymentReceivedHistoryDetails',
                tabPanelItemXtype: 'paymentreceivedhistorygrid',
                xtypeItemId: 'studentPaymentReceivedHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REFUNDS',
                tabPanelItemId: 'studentRefundHistoryDetails',
                tabPanelItemXtype: 'refundhistorygrid',
                xtypeItemId: 'studentRefundHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REFUNDABLE_PAYMENTS',
                tabPanelItemId: 'studentRefundablePaymentDetails',
                tabPanelItemXtype: 'refundablepaymentgrid',
                xtypeItemId: 'studentRefundablePaymentGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'POST_DATED_CHEQUES',
                tabPanelItemId: 'studentPostDatedChequeDetails',
                tabPanelItemXtype: 'postdatedchequegrid',
                xtypeItemId: 'studentPostDatedChequeGrid',
                render : true,
                defaultPanel: true,
               // hidden:true
            }, {
                tabPanelTitle: 'STUDENT_SCHOLERSHIP_LISTING',
                tabPanelItemId: 'studentscholershiplisting',
                tabPanelItemXtype: 'studentportalscholarshipstructure',
                xtypeItemId: 'STscholarshipListGridStructure',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'NSFAS_BURSARY_DETAIL',
                tabPanelItemId: 'NSFASBursaryDetailitemId',
                tabPanelItemXtype: 'nsfabursarydetailstructure',
                xtypeItemId: 'STNSFASbursarydetailstructure',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'PRO_FORMA_INVOICE',
                tabPanelItemId: 'proFormaInvoiceitemId',
                tabPanelItemXtype: 'proformainvoicestructure',
                xtypeItemId: 'proFormaInvoiceStructureId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'FUNDING_AND_MONITORING',
                tabPanelItemId: 'fundingAndMonitoringitemId',
                tabPanelItemXtype: 'fundingandmonitoringgrid',
                xtypeItemId: 'studentFundingAndMonitoringGrid',
                render : true,
                defaultPanel: true
            },{
            	 tabPanelTitle: 'FINANCIAL_SUPPORT',
                 tabPanelItemId: 'financialSupportitemId',
                 tabPanelItemXtype: 'financialsupportgrid',
                 xtypeItemId: 'studentFinancialSupportGrid',
                 render : true,
                 defaultPanel: true
            }],

            'SERVICES_COMMUNITIES': [{
                tabPanelTitle: 'SERVICES_HISTORY',
                tabPanelItemId: 'studentServicesHistoryDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'studentServiceHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'SERVICE_OPT_IN_OUT',
                tabPanelItemId: 'studentServicesOptDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'studentServiceOptGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_HISTORY',
                tabPanelItemId: 'studentCommunityHistoryDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'studentCommunityHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_OPT_IN_OUT',
                tabPanelItemId: 'studentCommunityOptDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'studentCommunityOptGrid',
                render : true,
                defaultPanel: true
            },{
	           	 tabPanelTitle: 'HOSTEL_PERSONAL_REQUIREMENTS',
	             tabPanelItemId: 'studentPersonHostelRequirement',
	             tabPanelItemXtype: 'studentpersonhostelrequirementform',
	             xtypeItemId: 'studentPersonHostelRequirementForm',
	             render: true,
	             defaultPanel: true
	        }],

            /*'FEEDBACK_DETAILS': [{
                tabPanelTitle: 'FEEDBACK_GIVEN',
                tabPanelItemId: 'studentFeedbackGivenDetails',
                tabPanelItemXtype: 'feedbackgivengrid',
                xtypeItemId: 'studentFeedbackGivenGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'FEEDBACK_RECEIVED',
                tabPanelItemId: 'studentFeedbackReceivedDetails',
                tabPanelItemXtype: 'feedbackreceivedgrid',
                xtypeItemId: 'studentFeedbackReceivedGrid',
                render : true,
                defaultPanel: true
            }],*/

            'DISCIPLINARY_ACTIVITY': [{
                tabPanelTitle: 'DISCIPLINARY_ACTIONS',
                tabPanelItemId: 'studentDisciplinaryActionDetails',
                tabPanelItemXtype: 'disciplinaryactiongrid',
                xtypeItemId: 'studentDisciplinaryActionGrid',
                render : true,
                defaultPanel: true
            }, {

                tabPanelTitle: 'SP_DISCIPLINARY_ACTIONS_SU',
                tabPanelItemId: 'studentDisciplinaryActionSUDetails',
                tabPanelItemXtype: 'disciplinaryactionsugrid',
                xtypeItemId: 'studentDisciplinaryActionSUGrid',
                render : true,
                defaultPanel: true
            
            },{
                tabPanelTitle: 'POSITIVE_INCIDENTS',
                tabPanelItemId: 'studentPositiveIncidentDetails',
                tabPanelItemXtype: 'positiveincidentgrid',
                xtypeItemId: 'studentPositiveIncidentGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'NEGATIVE_INCIDENTS',
                tabPanelItemId: 'studentNegativeIncidentDetails',
                tabPanelItemXtype: 'negativeincidentgrid',
                xtypeItemId: 'studentNegativeIncidentGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'HOLDS',
                tabPanelItemId: 'studentholdsdetails',
                tabPanelItemXtype: 'manageholdsstructure',
                xtypeItemId: 'manageholdsstructureItemId',
                render : true,
                defaultPanel: true
            } ],

            /*'KYS_DETAILS': [{
                tabPanelTitle: 'KYS',
                tabPanelItemId: 'studentKYSHistoryDetails',
                tabPanelItemXtype: 'kysdetailsgrid',
                xtypeItemId: 'studentKYSHistoryDetailsGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'PENDING_KYS',
                tabPanelItemId: 'studentPendingKYSDetails',
                tabPanelItemXtype: 'kysdetailsgrid',
                xtypeItemId: 'studentKYSPendingDetailsGrid',
                render : true,
                defaultPanel: true
            }],*/

            'DOCUMENT_HISTORY': [/*{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'studentDocumentDetails',
                tabPanelItemXtype: 'documentgrid',
                xtypeItemId: 'studentDocumentGrid',
                render : true,
                defaultPanel: true
            },*/{
            	tabPanelTitle: 'DOC_ONLINE_DOCUMENTS',
            	tabPanelItemId: 'studentOnlineDocuments',
            	tabPanelItemXtype: 'studentonlinedocumentgrid',
            	xtypeItemId: 'studentOnlineDocumentGridItemId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'DOC_PHYSICAL_DOCUMENTS',
            	tabPanelItemId: 'studentPhysicalDocuments',
            	tabPanelItemXtype: 'studentphysicaldocumentgrid',
            	xtypeItemId: 'studentPhysicalDocumentGridItemId',
            	render : true,
            	defaultPanel: true
            }],
            'APPOINTMENT': [{
            	tabPanelTitle: 'MANAGE_APPOINTMENT',
            	tabPanelItemId: 'studentAppointmentDetails',
            	tabPanelItemXtype: 'sgstudentappointmentdetailgrid',
            	xtypeItemId: 'SGStudentAppointmentDetailGridItemId',
            	render : true,
            	afterrender: 'dvRendered',
            	defaultPanel: true
            },{
            	
           	 	tabPanelTitle: 'APPOINTMENT_FOLLOW-UP',
                tabPanelItemId: 'studentmanageappointmentdetailsgrid',
                tabPanelItemXtype: 'applicationfollowupstructure', 
                xtypeItemId: 'studentmanageappointmentdetailsgridItemId',
                render : true,
                defaultPanel: true
            	
            }],
            'LIBRARY_DETAILS': [{
            	tabPanelTitle: 'CURRENTLY_ISSUED_STUDENT_BOOKS',
            	tabPanelItemId: 'studentLibraryDetails',
            	tabPanelItemXtype: 'sgstudentlibraryissuedbookdetailgrid',
            	xtypeItemId: 'SGStudentLibraryIssuedBookDetailGridItemId', 
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'LIBRARY_CIRCULATION_STUDENT_HISTORY',
            	tabPanelItemId: 'studentLibraryCirculationHistory',
            	tabPanelItemXtype: 'studentlibrarybookcirculationstructure',
            	xtypeItemId: 'studentlibrarybookcirculationstructureItemId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'LIBRARY_RESERVED_STUDENT_HISTORY',
            	tabPanelItemId: 'sgstudentlibraryreservedbookdetail',
            	tabPanelItemXtype: 'sgstudentlibraryreservedbookdetailgrid',
            	xtypeItemId: 'sgstudentlibraryreservedbookdetailgridItemId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'LIBRARY_FEE_DETATILS_STUDENT_HISTORY',
            	tabPanelItemId: 'libraryfeedetailsgriddetail',
            	tabPanelItemXtype: 'libraryfeedetailsgrid',
            	xtypeItemId: 'libraryfeedetailsgridItemId',
            	render : true,
            	defaultPanel: true
            }],
            'POST_GRADUATE_MANAGEMENT': [{
            	tabPanelTitle: 'STUDENT_THESIS_TITLE',
            	tabPanelItemId: 'studentthesistitleGrid',
            	tabPanelItemXtype: 'studentthesistitlegrid',
            	xtypeItemId: 'studentthesistitlegridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_POST_DOC_INFO',
            	tabPanelItemId: 'studentpostinfoGrid',
            	tabPanelItemXtype: 'studentpostinfogrid',
            	xtypeItemId: 'studentpostinfogridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_JOINT_DEGREE',
            	tabPanelItemId: 'studentjointdegreeGrid',
            	tabPanelItemXtype: 'studentjointdegreegrid',
            	xtypeItemId: 'studentjointdegreegridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_OWN_PROGRESS_REPORT',
            	tabPanelItemId: 'studentownprogressreportgrid',
            	tabPanelItemXtype: 'studentownprogressreportgrid',
            	xtypeItemId: 'studentownprogressreportgridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'FUNCTIONARY_PROGRESS_REPORT',
            	tabPanelItemId: 'functionaryprogressreportgrid',
            	tabPanelItemXtype: 'functionaryprogressreportgrid',
            	xtypeItemId: 'functionaryprogressreportgridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_MOU',
            	tabPanelItemId: 'studentmougrid',
            	tabPanelItemXtype: 'studentmougrid',
            	xtypeItemId: 'studentmougridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_ETHICS_CLEARANCE_LETTER',
            	tabPanelItemId: 'studentethicsclearancelettergrid',
            	tabPanelItemXtype: 'studentethicsclearancelettergrid',
            	xtypeItemId: 'studentethicsclearancelettergridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'EXAMINERS_REPORT',
            	tabPanelItemId: 'studentExaminersReportGrid',
            	tabPanelItemXtype: 'studentexaminersreportgrid',
            	xtypeItemId: 'studentExaminersReportGridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'STUDENT_THESIS_UPLOAD',
            	tabPanelItemId: 'studentThesisUploadGrid',
            	tabPanelItemXtype: 'studentthesisuploadgrid',
            	xtypeItemId: 'studentThesisUploadGridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT',
            	tabPanelItemId: 'independentnonexaminingchairpersonreportgrid',
            	tabPanelItemXtype: 'independentnonexaminingchairpersonreportgrid',
            	xtypeItemId: 'independentnonexaminingchairpersonreportgridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'FUNCTIONARY_DETAILS',
            	tabPanelItemId: 'functionaryDetailsGrid',
            	tabPanelItemXtype: 'functionarydetailsgrid',
            	xtypeItemId: 'functionarydetailsgridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'NOMINATE_EXAMINERS',
            	tabPanelItemId: 'nominateexaminersgrid',
            	tabPanelItemXtype: 'nominateexaminersgrid',
            	xtypeItemId: 'nominateexaminersgridId',
            	render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'PROOF_OF_ACTIVITY',
            	tabPanelItemId: 'proofofactivitygrid',
            	tabPanelItemXtype: 'proofofactivitygrid',
            	xtypeItemId: 'proofofactivitygridId',
            	render : true,
            	defaultPanel: true
            }],
            'FLAG_LIST':[{
            	tabPanelTitle: 'RAISED_FLAG_LIST',
            	tabPanelItemId: 'flagliststudentgrid',
            	tabPanelItemXtype: 'flagliststudentgrid',
            	xtypeItemId: 'flagliststudentgridId',
            	render : true,
            	defaultPanel: true
            }]
        };
        return studentProfileLink;
    },

    getFacultyProfileLink: function() {
        var facultyProfileLink = {
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: 'PERSONAL_DETAILS',
                tabPanelItemId: 'facultyPersonalDetails',
                tabPanelItemXtype: 'employeepersonalinformationform',
                xtypeItemId: 'facultyPersonalInformationForm',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADDRESSES',
                tabPanelItemId: 'facultyAddressDetails',
                tabPanelItemXtype: 'facultyaddressdetails',
                xtypeItemId: 'facultyAddressTemplate',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'FAMILY_DETAILS',
                tabPanelItemId: 'facultyFamilyDetails',
                tabPanelItemXtype: 'facultyfamilydetailgrid',
                xtypeItemId: 'facultyFamilyDetailGridItemId',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'IDENTITY_DETAILS',
                tabPanelItemId: 'facultyIdentityDetails',
                tabPanelItemXtype: 'identitydetailsgrid',
                xtypeItemId: 'facultyIdentityDetailsGrid',
                render : true,
                defaultPanel: true
            }, {
            	tabPanelTitle: 'OTHER_INFORMATION',
                tabPanelItemId: 'facultyOtherInformationDetails',
                tabPanelItemXtype: 'otherinformationdetailsform',
                xtypeItemId: 'facultyOtherinformationDetailsForm',
                render : true,
                defaultPanel: true
            }, {
            	 tabPanelTitle: 'SSO_DETAILS',
                 tabPanelItemId: 'facultyssodetailsgrid',
                 tabPanelItemXtype: 'ssodetailsgrid',
                 xtypeItemId: 'facultyssodetailsgridItemId',
                 render : true,
                 defaultPanel: true
            },{
            	 tabPanelTitle: 'EMPLOYEES_ADDITIONAL_DETAILS',
                 tabPanelItemId: 'empadditionaldetailsformId',
                 tabPanelItemXtype: 'empadditionaldetailsform',
                 xtypeItemId: 'empadditionaldetailsformItemId',
                 render : true,
                 defaultPanel: true
            }],

            'PAST_HISTORY': [{
                tabPanelTitle: 'EDUCATION',
                tabPanelItemId: 'facultyEducationHistoryDetails',
                tabPanelItemXtype: 'educationhistorygrid',
                xtypeItemId: 'facultyEducationHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'WORK_EXPERIENCE',
                tabPanelItemId: 'facultyWorkExperienceDetails',
                tabPanelItemXtype: 'workexperiencegrid',
                xtypeItemId: 'facultyWorkExperienceGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'MEDICAL_HISTORY',
                tabPanelItemId: 'facultyMedicalDetails',
                tabPanelItemXtype: 'medicalgrid',
                xtypeItemId: 'facultyMedicalGrid',
                render: true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'VACCINATION',
                tabPanelItemId: 'facultyVaccinationDetails',
                tabPanelItemXtype: 'vaccinationgridforapplicantfaculty',
                xtypeItemId: 'facultyVaccinationGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'EXTRA_CURRICULUM',
                tabPanelItemId: 'facultyExtraCurricularDetails',
                tabPanelItemXtype: 'extracurriculargrid',
                xtypeItemId: 'facultyExtraCurricularGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'RESEARCH_TYPE',
                tabPanelItemId: 'facultyResearchTypeDetails',
                tabPanelItemXtype: 'researchtypegrid',
                xtypeItemId: 'facultyResearchTypeGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'SEMINAR_DETAILS',
                tabPanelItemId: 'facultySeminarDetails',
                tabPanelItemXtype: 'seminardetailsgrid',
                xtypeItemId: 'facultySeminarDetailsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'INSURANCE_HISTORY',
                tabPanelItemId: 'facultyInsuranceHistoryDetails',
                tabPanelItemXtype: 'insurancehistorygrid',
                xtypeItemId: 'facultyInsuranceHistoryGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PHYSICAL_CHARACTERISTICS',
                tabPanelItemId: 'facultyPhysicalCharacteristicsDetails',
                tabPanelItemXtype: 'physicalcharacteristicsgrid',
                xtypeItemId: 'facultyPhysicalCharacteristicsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'PATENT_DETAILS',
                tabPanelItemId: 'facultyPatentDetails',
                tabPanelItemXtype: 'patentdetailsgrid',
                xtypeItemId: 'facultyPatentDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'TRAINING_DETAILS',
                tabPanelItemId: 'facultyTrainingPersonDetails',
                tabPanelItemXtype: 'trainingpersondetailsgrid',
                xtypeItemId: 'facultyTrainingPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'HOSTEL_DETAILS',
                tabPanelItemId: 'facultyHostelPersonDetails',
                tabPanelItemXtype: 'hostelpersondetailsgrid',
                xtypeItemId: 'facultyHostelPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'TRANSPORT_DETAILS',
                tabPanelItemId: 'facultytransportpersondetails',
                tabPanelItemXtype: 'transportpersondetailsgrid',
                xtypeItemId: 'facultyTransportPersonDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'COMPETITIVE_EXAM',
            	tabPanelItemId: 'facultyCompetitiveExamDetails',
            	tabPanelItemXtype: 'competitiveexamgrid',
            	xtypeItemId: 'facultyCompetitiveExamGrid',
            	render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'CHURCH_INFORMATION_DETAILS',
                tabPanelItemId: 'facultyChurchInformationDetails',
                tabPanelItemXtype: 'churchinformationgrid',
                xtypeItemId: 'facultyChurchInformationGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'COMMUNICATION_HISTORY',
                tabPanelItemId: 'communicationhistoryDetails',
                tabPanelItemXtype: 'communicationhistorystructure',
                xtypeItemId: 'facultycommunicationhistorystructureItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'FACULTY_NON_ACADEMIC_ACHIEVEMENTS',
                tabPanelItemId: 'nonacademicachievementsDetails',
                tabPanelItemXtype: 'facultynonacademicachievementsgrid',
                xtypeItemId: 'facultynonacademicachievementsgrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'REFERENCES',
                tabPanelItemId: 'employeeReferences',
                tabPanelItemXtype: 'employeeReferenceGrid',
                xtypeItemId: 'employeeReferenceGrid',
                render : true,
                defaultPanel: true
            },
            {
                tabPanelTitle: 'QUALIFICATION_DETAILS',
                tabPanelItemId: 'qualificationDetailsItemId',
                tabPanelItemXtype: 'qualificationdetailsgrid',
                xtypeItemId: 'qualificationDetailsFormItemId',
                render : true,
                defaultPanel: true
            }
            /*, {
                tabPanelTitle: 'TRAINING',
                tabPanelItemId: 'facultyTrainingDetails',
                tabPanelItemXtype: 'trainingdetailsgrid',
                xtypeItemId: 'facultyTrainingDetailsGrid',
                render : false,
                defaultPanel: true
            }*/],
            
            'COURSE_EXECUTION': [{
                tabPanelTitle: 'SCHEDULE',
                tabPanelItemId: 'facultyScheduleDetails',
                tabPanelItemXtype: 'scheduledetails',
                xtypeItemId: 'facultyScheduleCalender',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'ATTENDANCE',
                tabPanelItemId: 'facultyAttendanceDetailsTab',
                tabPanelItemXtype: 'facultyattendancedetails',
                xtypeItemId: 'facultyAttendanceDetails',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'BIOMETRIC_MACHINE_DETAILS',
                tabPanelItemId: 'facultybmimachinedetailsTab',
                tabPanelItemXtype: 'facultybmimachinedetailsstructure',
                //tabPanelItemXtype: 'attendancedetails',
                xtypeItemId: 'facultybmimachinedetailsstructureItemId',
                render : true,
                defaultPanel: false
            }, {
                tabPanelTitle: 'PROGRAM_COURSES',
                tabPanelItemId: 'facultyProgramCoursesDetails',
                tabPanelItemXtype: 'programcoursesearchpanel',
                xtypeItemId: 'facultyProgramCourseSearchPanel',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'DEVELOPMENT_PLAN',
                tabPanelItemId: 'developmentPlanDetailsTab',
                tabPanelItemXtype: 'developmentplandetails',
                xtypeItemId: 'developmentPlanDetails',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'COURSE_INTERESTS',
                tabPanelItemId: 'courseinterestsDetailsTab',
                tabPanelItemXtype: 'facultycourseinterestdetails',
                xtypeItemId: 'facultycourseinterestdetails',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'FACULTY_EXAMINATION_DUTY',
                tabPanelItemId: 'examinationDutyDetailsTab',
                tabPanelItemXtype: 'examinationdutydetails',
                xtypeItemId: 'examinationDutyDetails',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: 'TEACHING_HOURS',
                tabPanelItemId: 'facultyTeachingHourTab',
                tabPanelItemXtype: 'facultyteachinghourdetails',
                xtypeItemId: 'facultyTeachingHourdetails',
                render : true,
                defaultPanel: false
            }/*, {
                tabPanelTitle: 'FACULTY_PERFORMANCE',
                tabPanelItemId: 'facultyPerformanceTrackerDetails',
                tabPanelItemXtype: 'facultyperformanceform',
                xtypeItemId: 'facultyPerformanceForm',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'EVALUATION_PLAN',
                tabPanelItemId: 'facultyEvaluationPlan',
                tabPanelItemXtype: 'facultyevaluationdetails',
                xtypeItemId: 'facultyEvaluationDetails',
                render : true,
                defaultPanel: true
            }*/],

            'SERVICES_COMMUNITIES': [{
                tabPanelTitle: 'SERVICES_HISTORY',
                tabPanelItemId: 'facultyServicesHistoryDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'facultyServiceHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'SERVICE_OPT_IN_OUT',
                tabPanelItemId: 'facultyServicesOptDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'facultyServiceOptGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_HISTORY',
                tabPanelItemId: 'facultyCommunityHistoryDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'facultyCommunityHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_OPT_IN_OUT',
                tabPanelItemId: 'facultyCommunityOptDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'facultyCommunityOptGrid',
                render : true,
                defaultPanel: true
            }],
            
            'REQUESTS': [{
                tabPanelTitle: 'REQUEST_RAISED_HISTORY',
                tabPanelItemId: 'facultyRequestRaisedHistoryDetails',
                tabPanelItemXtype: 'requestraisedhistorygrid',
                xtypeItemId: 'facultyRequestRaisedHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REQUEST_EXECUTED_HISTORY',
                tabPanelItemId: 'studentRequestExecutedHistoryDetails',
                tabPanelItemXtype: 'requestexecutedhistorygrid',
                xtypeItemId: 'facultyRequestExecutedHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REQUEST_PENDING_DESCISION',
                tabPanelItemId: 'studentRequestPendingDecisionDetails',
                tabPanelItemXtype: 'requestpendingdecisiongrid',
                xtypeItemId: 'facultyRequestPendingDecisionGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REQUEST_PENDING_ACTION',
                tabPanelItemId: 'studentRequestPendingActionDetails',
                tabPanelItemXtype: 'requestpendingactiongrid',
                xtypeItemId: 'facultyRequestPendingActionGrid',
                render : true,
                defaultPanel: true
            }],
            
            /*'FEEDBACK_SURVEY': [{
                tabPanelTitle: 'FEEDBACK_GIVEN',
                tabPanelItemId: 'facultyFeedbackGivenDetails',
                tabPanelItemXtype: 'feedbackgivengrid',
                xtypeItemId: 'facultyFeedbackGivenGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'FEEDBACK_RECEIVED',
                tabPanelItemId: 'facultyFeedbackReceivedDetails',
                tabPanelItemXtype: 'feedbackreceivedgrid',
                xtypeItemId: 'facultyFeedbackReceivedGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'SURVEY_HISTORY',
                tabPanelItemId: 'facultySurveyHistoryDetails',
                tabPanelItemXtype: 'surveyquicksearchpanel',
                xtypeItemId: 'facultySurveyHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'ACTIVE_SURVEY',
                tabPanelItemId: 'facultyActiveSurveyGrid',
                tabPanelItemXtype: 'activesurveygrid',
                xtypeItemId: 'facultyActiveSurveyGrid',
                render : true,
                defaultPanel: true
            }],*/
            
            'PAYMENT_REFUND_HISTORY': [{
                tabPanelTitle: 'BILLS',
                //tabPanelTitle: 'PENDING_BILLS',
                tabPanelItemId: 'facultyPendingBillDetails',
                tabPanelItemXtype: 'pendingbillsgrid',
                xtypeItemId: 'facultyPendingBillsGrid',
                render : true,
                defaultPanel: true
            }, {
                //tabPanelTitle: 'PAYMENT_RECIEVED',
                tabPanelTitle: 'RECEIPTS',
                tabPanelItemId: 'facultyPaymentReceivedHistoryDetails',
                tabPanelItemXtype: 'paymentreceivedhistorygrid',
                xtypeItemId: 'facultyPaymentReceivedHistoryGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PAYMENT_MADE_HISTORY',
                tabPanelItemId: 'facultyPaymentMadeDetails',
                tabPanelItemXtype: 'paymentmadehistorygrid',
                xtypeItemId: 'facultyPaymentMadeGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'POST_DATED_CHEQUES',
                tabPanelItemId: 'facultyPostDatedChequeDetails',
                tabPanelItemXtype: 'postdatedchequegrid',
                xtypeItemId: 'facultyPostDatedChequeGrid',
                render : true,
                defaultPanel: true
            }
            //Removed these tab from faculty as discussed with nitin and shrikantji
            /*, {
                tabPanelTitle: 'REFUNDS',
                tabPanelItemId: 'facultyRefundHistoryDetails',
                tabPanelItemXtype: 'refundhistorygrid',
                xtypeItemId: 'facultyRefundHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'REFUNDABLE_PAYMENTS',
                tabPanelItemId: 'facultyRefundablePaymentDetails',
                tabPanelItemXtype: 'refundablepaymentgrid',
                xtypeItemId: 'facultyRefundablePaymentGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PAYMENT_SETTINGS',
                tabPanelItemId: 'facultyPaymentSettingsDetails',
                tabPanelItemXtype: 'paymentsettingsgrid',
                xtypeItemId: 'facultyPaymentSettingsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'UNPAID_FACULTY_BILLS',
                tabPanelItemId: 'facultyUnpaidFacultyBillDetails',
                tabPanelItemXtype: 'unpaidfacultybillgrid',
                xtypeItemId: 'facultyUnpaidFacultyBillGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'UNBILLED_SESSIONS',
                tabPanelItemId: 'facultyUnbilledSessions',
                tabPanelItemXtype: 'unbilledsessiongrid',
                xtypeItemId: 'facultyUnbilledSessionGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'OVER_PAYMENTS',
                tabPanelItemId: 'facultyOverPaymentDetails',
                tabPanelItemXtype: 'overpaymentgrid',
                xtypeItemId: 'facultyOverPaymentGrid',
                render : true,
                defaultPanel: true
            }*/],
            
            'HR_PROFILE': [{
                tabPanelTitle: 'WORK_HOURS',
                tabPanelItemId: 'workHoursId',
                tabPanelItemXtype: 'staffworkhoursgrid',
                xtypeItemId: 'facultyWorkHoursGrid',
                render : true,
                defaultPanel: true
            }],

            
            'DISCIPLINARY_ACTIVITY': [{
                tabPanelTitle: 'DISCIPLINARY_ACTIONS',
                tabPanelItemId: 'facultyDisciplinaryActionDetails',
                tabPanelItemXtype: 'disciplinaryactiongrid',
                xtypeItemId: 'facultyDisciplinaryActionGrid',
                render : true,
                defaultPanel: true
            }, /*{
                tabPanelTitle: 'NEGATIVE_INCIDENTS',
                tabPanelItemId: 'facultyNegativeIncidentDetails',
                tabPanelItemXtype: 'negativeincidentgrid',
                xtypeItemId: 'facultyNegativeIncidentGrid',
                render : true,
                defaultPanel: true
            },*/ {
                tabPanelTitle: 'POSITIVE_INCIDENTS',
                tabPanelItemId: 'facultyPositiveIncidentDetails',
                tabPanelItemXtype: 'positiveincidentgrid',
                xtypeItemId: 'facultyPositiveIncidentGrid',
                render : true,
                defaultPanel: true
            }],

            'DOCUMENT_HISTORY': [/*{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'facultyDocumentDetails',
                tabPanelItemXtype: 'documentgrid',
                xtypeItemId: 'facultyDocumentGrid',
                render : true,
                defaultPanel: true
            },*/{
                tabPanelTitle: 'DOC_ONLINE_DOCUMENTS',
                tabPanelItemId: 'facultyOnlineDocuments',
                tabPanelItemXtype: 'onlinedocumentgrid',
                xtypeItemId: 'facultyOnlineDocumentGridItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'DOC_PHYSICAL_DOCUMENTS',
                tabPanelItemId: 'facultyPhysicalDocuments',
                tabPanelItemXtype: 'physicaldocumentgrid',
                xtypeItemId: 'facultyPhysicalDocumentGridItemId',
                render : true,
                defaultPanel: true
            }],
            'LIBRARY_DETAILS': [{
                tabPanelTitle: 'CURRENTLY_ISSUED_EMPLOYEE_BOOKS',
                tabPanelItemId: 'studentLibraryDetails',
                tabPanelItemXtype: 'sgstudentlibraryissuedbookdetailgrid',
                xtypeItemId: 'SGStudentLibraryIssuedBookDetailGridItemId',
                render : true,
                defaultPanel: true
                },{
                	tabPanelTitle: 'LIBRARY_CIRCULATION_EMPLOYEE_HISTORY',
                	tabPanelItemId: 'studentLibraryCirculationHistory',
                	tabPanelItemXtype: 'studentlibrarybookcirculationstructure',
                	xtypeItemId: 'studentlibrarybookcirculationstructureItemId',
                	render : true,
                	defaultPanel: true
                },{
                	tabPanelTitle: 'LIBRARY_RESERVED_EMPLOYEE_HISTORY',
                	tabPanelItemId: 'sgstudentlibraryreservedbookdetail',
                	tabPanelItemXtype: 'sgstudentlibraryreservedbookdetailgrid',
                	xtypeItemId: 'sgstudentlibraryreservedbookdetailgridItemId',
                	render : true,
                	defaultPanel: true
                },{
                	tabPanelTitle: 'LIBRARY_FEE_DETATILS_EMPLOYEE_HISTORY',
                	tabPanelItemId: 'libraryfeedetailsgriddetail',
                	tabPanelItemXtype: 'libraryfeedetailsgrid',
                	xtypeItemId: 'libraryfeedetailsgridItemId',
                	render : true,
                	defaultPanel: true
                }]
        };
        return facultyProfileLink;
    },
    
    getCreateFacultyProfileLink: function() {
        var facultyProfileLink = {
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: 'PERSONAL_DETAILS',
                tabPanelItemId: 'facultyPersonalDetails',
                tabPanelItemXtype: 'personalinformationform',
                xtypeItemId: 'facultyPersonalInformationForm',
                isMandatoryTab : true,
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADDRESSES',
                tabPanelItemId: 'facultyAddressDetails',
                tabPanelItemXtype: 'facultyaddressdetails',
                xtypeItemId: 'facultyAddressTemplate',
                isMandatoryTab : true,
                render : true,
                defaultPanel: false
            }],

            'PAST_HISTORY': [{
                tabPanelTitle: 'EDUCATION',
                tabPanelItemId: 'facultyEducationHistoryDetails',
                tabPanelItemXtype: 'educationhistorygrid',
                xtypeItemId: 'facultyEducationHistoryGrid',
                isMandatoryTab : true,
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'WORK_EXPERIENCE',
                tabPanelItemId: 'facultyWorkExperienceDetails',
                tabPanelItemXtype: 'workexperiencegrid',
                xtypeItemId: 'facultyWorkExperienceGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'MEDICAL_HISTORY',
                tabPanelItemId: 'facultyMedicalDetails',
                tabPanelItemXtype: 'medicalgrid',
                xtypeItemId: 'facultyMedicalGrid',
                render: true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'VACCINATION',
                tabPanelItemId: 'facultyVaccinationDetails',
                tabPanelItemXtype: 'vaccinationgridforapplicantfaculty',
                xtypeItemId: 'facultyVaccinationGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'EXTRA_CURRICULUM',
                tabPanelItemId: 'facultyExtraCurricularDetails',
                tabPanelItemXtype: 'extracurriculargrid',
                xtypeItemId: 'facultyExtraCurricularGrid',
                render : true,
                defaultPanel: true
            }/*, {
                tabPanelTitle: 'TRAINING',
                tabPanelItemId: 'facultyTrainingDetails',
                tabPanelItemXtype: 'trainingdetailsgrid',
                xtypeItemId: 'facultyTrainingDetailsGrid',
                render : true,
                defaultPanel: true
            }*/],
            
            /*'COURSE_EXECUTION': [{
                tabPanelTitle: 'PROGRAM_COURSES',
                tabPanelItemId: 'facultyProgramCoursesDetails',
                tabPanelItemXtype: 'programCoursesGrid',
                xtypeItemId: '',
                isMandatoryTab : true,
                render : true,
                defaultPanel: false
            }],
            
            'PAYMENT_REFUND_HISTORY': [{
                tabPanelTitle: 'PAYMENT_SETTINGS',
                tabPanelItemId: 'facultyPaymentSettingsDetails',
                tabPanelItemXtype: 'paymentsettingsgrid',
                xtypeItemId: 'paymentSettingsGrid',
                render : true,
                defaultPanel: true
            }],*/

            'SERVICES_COMMUNITIES': [{
                tabPanelTitle: 'SERVICE_OPT_IN',
                tabPanelItemId: 'facultyServicesOptDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'facultyServiceOptGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_OPT_IN',
                tabPanelItemId: 'facultyCommunityOptDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'facultyCommunityOptGrid',
                render : true,
                defaultPanel: true
            }],

            'DOCUMENT_HISTORY': [{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'facultyDocumentDetails',
                tabPanelItemXtype: 'documentgrid',
                xtypeItemId: 'facultyDocumentGrid',
                render : true,
                defaultPanel: true
            }]
        };
        return facultyProfileLink;
    },
    
    getApplicantProfileLink: function() {
        var applicantProfileLink = {
        		
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: 'STUDENT_PERSONAL_DETAILS',
                tabPanelItemId: 'applicantPersonalDetails',
                tabPanelItemXtype: 'personalinformationform',
                xtypeItemId: 'applicantPersonalInformationForm',
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADDRESSES',
                tabPanelItemId: 'applicantAddressDetails',
                tabPanelItemXtype: 'addressdetails',
                xtypeItemId: 'applicantAddressTemplate',
                defaultPanel: false
            }, {
                tabPanelTitle: 'PARENTS_GUARDIANS',
                tabPanelItemId: 'studentParentGuardianDetails',
                tabPanelItemXtype: 'parentguardiangrid',
                xtypeItemId: 'applicantParentGuardianGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'FEE_PAYERS',
                tabPanelItemId: 'applicantFeePayerDetail',
                tabPanelItemXtype: 'feepayerdetailgrid',
                xtypeItemId: 'applicantFeePayerDetailGridItemId',
                defaultPanel: true
            }, {
                tabPanelTitle: 'SIBLING',
                tabPanelItemId: 'studentSiblingDetails',
                tabPanelItemXtype: 'siblingdetailsgrid',
                xtypeItemId: 'applicantSiblingDetailsGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'IDENTITY_DETAILS',
                tabPanelItemId: 'applicantIdentityDetails',
                tabPanelItemXtype: 'identitydetailsgrid',
                xtypeItemId: 'applicantIdentityDetailsGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'OTHER_INFORMATION',
                tabPanelItemId: 'applicantOtherInformationDetails',
                tabPanelItemXtype: 'otherinformationdetailsform',
                xtypeItemId: 'applicantOtherinformationDetailsForm',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PASSPORT',
                tabPanelItemId: 'applicantpassportgrid',
                tabPanelItemXtype: 'applicantpassportgrid',
                xtypeItemId: 'applicantpassportgridId',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'VISA',
                tabPanelItemId: 'applicantvisagrid',
                tabPanelItemXtype: 'applicantvisagrid',
                xtypeItemId: 'applicantvisagridId',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'PERMIT',
                tabPanelItemId: 'applicantpermitgrid',
                tabPanelItemXtype: 'applicantpermitgrid',
                xtypeItemId: 'applicantpermitgridId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'INSURANCE',
                tabPanelItemId: 'applicantInsuranceDetailsGridId',
                tabPanelItemXtype: 'applicantinsurancedetailsgrid',
                xtypeItemId: 'applicantInsuranceDetailsGrid',
                render : true,
                defaultPanel: true
            }],

            'APPLICATION_AND_ADMISSION': [{
                tabPanelTitle: 'APPLICATION_DETAILS',
                tabPanelItemId: 'applicantApplicationDetails',
                tabPanelItemXtype: 'applicationdetails',
                xtypeItemId: '',
                defaultPanel: false
            }, {
                tabPanelTitle: 'REFERENCES',
                tabPanelItemId: 'applicantReferences',
                tabPanelItemXtype: 'referencegrid',
                xtypeItemId: 'referenceGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADMISSION_DETAILS',
                tabPanelItemId: 'applicantAdmissionDetails',
                tabPanelItemXtype: 'admissionprogramgrid',
                xtypeItemId: 'admissionDetailGrid',
                defaultPanel: true
            },/* {
                tabPanelTitle: 'MID_TERM_ADMISSION',
                tabPanelItemId: 'applicantMidTermAdmissionDetails',
                tabPanelItemXtype: 'midtermadmission',
                xtypeItemId: 'applicantmidtermadmission',
                defaultPanel: false
            }, */{
                tabPanelTitle: 'CHANGE_APPLICATION_PROGRAM',
                tabPanelItemId: 'changeApplicationProgramDetails',
                tabPanelItemXtype: 'changeprogramgrid',
                xtypeItemId: 'changeprogramGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'CONDITIONS_FOR_ADMISSION',
                tabPanelItemId: 'conditionsForAdmission',
                tabPanelItemXtype: 'applicationconditionsforadmission',
                xtypeItemId: 'applicationconditionsforadmissionFormId',
                defaultPanel: true
            }, {
                tabPanelTitle: 'PROGRAM_WISE_CONDITIONS_FOR_ADMISSION',
                tabPanelItemId: 'programWiseConditionsForAdmission',
                tabPanelItemXtype: 'applicationprogramwiseconditionsforadmission',
                xtypeItemId: 'applicationProgramWiseConditionsforAdmissionFormId',
                defaultPanel: true
            },
            {
                tabPanelTitle: 'REVIEW_DETAILS',
                tabPanelItemId: 'reviewdetails',
                tabPanelItemXtype: 'applicationreviewdetails',
                xtypeItemId: 'reviewdetails',
                defaultPanel: true
            },{
                tabPanelTitle: 'ELIGIBILITY_DETAILS',
                tabPanelItemId: 'eligibilityDetailsForm',
                tabPanelItemXtype: 'eligibilitydetailsform',
                xtypeItemId: 'eligibilitydetailsformItemId',
                defaultPanel: true
            },{
                tabPanelTitle: 'CONDITIONS_REVIEW_DETAILS',
                tabPanelItemId: 'conditionsreviewdetails',
                tabPanelItemXtype: 'applicationconditionsreviewdetails',
                xtypeItemId: 'conditionsreviewdetails',
                defaultPanel: true
            },{
                tabPanelTitle: 'APPLICATIONS_CHECK_LIST_DETAILS',
                tabPanelItemId: 'applicationdetailschecklistgrid',
                tabPanelItemXtype: 'applicationdetailschecklistgrid',
                xtypeItemId: 'applicationdetailschecklistgridId',
                defaultPanel: true
            },{
                tabPanelTitle: 'APPLICATION_AND_ADMISSION_COMMENTS',
                tabPanelItemId: 'applicationandadmissioncomments',
                tabPanelItemXtype: 'applicationandadmissioncomments',
                xtypeItemId: 'applicationandadmissioncommentsId',
                defaultPanel: true
            },{
                tabPanelTitle: 'SALESFORCE_ADMISSION_DETAILS',
                tabPanelItemId: 'salesforceadmissiondetailsgrid',
                tabPanelItemXtype: 'salesforceadmissiondetailsgrid',
                xtypeItemId: 'salesforceadmissiondetailsgridId',
                defaultPanel: true
            },{
                tabPanelTitle: 'DOCUMENTS_AND_NOTES',
                tabPanelItemId: 'applicationacademictopicStructure',
                tabPanelItemXtype: 'applicationacademictopicStructure',
                xtypeItemId: 'applicationacademictopicStructureId',
                defaultPanel: true
            },{
                tabPanelTitle: 'APPLICANT_TRANSFER_CREDITS',
                tabPanelItemId: 'transfercreditsstructure',
                tabPanelItemXtype: 'transfercreditsstructure',
                xtypeItemId: 'transfercreditsstructureId',
                defaultPanel: true
            }
            ],
            
            'HISTORY': [{
                tabPanelTitle: 'EDUCATION',
                tabPanelItemId: 'applicantEducationHistoryDetails',
                tabPanelItemXtype: 'educationhistorygrid',
                xtypeItemId: 'applicantEducationHistoryGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'WORK_EXPERIENCE',
                tabPanelItemId: 'applicantWorkExperienceDetails',
                tabPanelItemXtype: 'workexperiencegrid',
                xtypeItemId: 'applicantWorkExperienceGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'MEDICAL_HISTORY',
                tabPanelItemId: 'applicantMedicalHistory',
                tabPanelItemXtype: 'medicalgrid',
                xtypeItemId: 'applicantMedicalGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'VACCINATION',
                tabPanelItemId: 'applicantVaccinationDetails',
                tabPanelItemXtype: 'vaccinationgridforapplicantfaculty',
                xtypeItemId: 'applicantVaccinationGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'EXTRA_CURRICULUM',
                tabPanelItemId: 'applicantExtraCurricularDetails',
                tabPanelItemXtype: 'extracurriculargrid',
                xtypeItemId: 'applicantExtraCurricularGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'COMPETITIVE_EXAM',
                tabPanelItemId: 'applicantCompetitiveExamDetails',
                tabPanelItemXtype: 'competitiveexamgrid',
                xtypeItemId: 'applicantCompetitiveExamGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'MD_MEDICAL_DETAILS',
                tabPanelItemId: 'applicantMedicalDetails',
                tabPanelItemXtype: 'medicaldetailsform',
                xtypeItemId: 'applicantMedicalDetailsFormItemId',
                defaultPanel: true
            }, {
                tabPanelTitle: 'CHURCH_INFORMATION_DETAILS',
                tabPanelItemId: 'applicantChurchInformationDetails',
                tabPanelItemXtype: 'churchinformationgrid',
                xtypeItemId: 'applicantChurchInformationGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'APPLICANT_DETAILS_FORM',
                tabPanelItemId: 'applicantDetailsFormItem',
                tabPanelItemXtype: 'applicantdetailsform',
                xtypeItemId: 'applicantDetailsFormItemId',
                defaultPanel: true
            },{
                tabPanelTitle: 'COMMUNICATION_HISTORY',
                tabPanelItemId: 'communicationhistoryDetails',
                tabPanelItemXtype: 'communicationhistorystructure',
                xtypeItemId: 'applicantcommunicationhistorystructureItemId',
                defaultPanel: true
            },{
                tabPanelTitle: 'NON_ACADEMIC_ACHIEVEMENTS',
                tabPanelItemId: 'applicantNonAcademicAchievements',
                tabPanelItemXtype: 'nonacademicachievementsgrid',
                xtypeItemId: 'applicantnonacademicachievementsgridItemId',
                defaultPanel: true
            },{
                tabPanelTitle: 'SOCIO_ECONOMIC_INFORMATION',
                tabPanelItemId: 'applicantSocioEconomicInformation',
                tabPanelItemXtype: 'socioeconomicinformationform',
                xtypeItemId: 'admApplicantSocioEconomicFormItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'POST_SCHOOL_STUDIES',
                tabPanelItemId: 'applicantPostSchoolStudies',
                tabPanelItemXtype: 'postschoolstudiesgrid',
                xtypeItemId: 'applicantPostSchoolStudiesGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'EDUCATION_DETAILS',
                tabPanelItemId: 'applicantEducationDetails',
                tabPanelItemXtype: 'applicanteducationdetailsgrid',
                xtypeItemId: 'applicantEducationDetailsGridItemId',
                defaultPanel: true
            },{
                tabPanelTitle: 'LANGUAGE_INFORMATION',
                tabPanelItemId: 'applicantLanguagesInformation',
                tabPanelItemXtype: 'applicantlanguageinformationgrid',
                xtypeItemId: 'applicantLanguagesInformationGridItemId',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'HEALTH_INFORMATION',
                tabPanelItemId: 'applicantHealthInformation',
                tabPanelItemXtype: 'applicanthealthinformationgrid',
                xtypeItemId: 'applicantHealthInformationGridItemId',
                render : true,
                defaultPanel: true
            }
            ],            

            'FINANCIAL': [{
                tabPanelTitle: 'PRE_ADMISSION_PAYMENTS',
                tabPanelItemId: 'ApplicantPreAdmissionPaymentsGrid',
                tabPanelItemXtype: 'preadmissionpaymentsgrid',
                xtypeItemId: 'preAdmissionPaymentGrid',
                defaultPanel: true
            }, {
                tabPanelTitle: 'PRE_ADMISSION_REFUNDS',
                tabPanelItemId: 'ApplicantPreAdmissionRefundsGrid',
                tabPanelItemXtype: 'preadmissionrefundsgrid',
                xtypeItemId: 'preAdmissionRefundGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'PRE_ADMISSION_FEE_PLANS',
                tabPanelItemId: 'ApplicantPreAdmissionFeePlanGrid',
                tabPanelItemXtype: 'preadmissionfeeplansgrid',
                xtypeItemId: 'preAdmissionFeePlanGrid',
                defaultPanel: true
            },/*{
                tabPanelTitle: 'ONLINE_PAYMENT',
                tabPanelItemId: 'ApplicantOnlinepaymentGrid',
                tabPanelItemXtype: 'onlinepaymentgrid',
                xtypeItemId: 'onlinePaymentGrid',
                defaultPanel: true
            },*/{
                tabPanelTitle: 'ONLINE_PAYMENT',
                tabPanelItemId: 'onlinepaymentapplicantstructureid',
                tabPanelItemXtype: 'onlinepaymentapplicantstructure', //'onlinepaymentbilllevelapplicant',
                xtypeItemId: 'onlinepaymentapplicantstructureitemid',
                defaultPanel: true
            },{
                tabPanelTitle: 'RECEIPTS',
                tabPanelItemId: 'ReceiptGridForApplicant',
                tabPanelItemXtype: 'receiptgridforapplicant',
                xtypeItemId: 'receiptgridforapplicant',
                defaultPanel: true
            },{
                tabPanelTitle: 'NSFAS_BURSARY_DETAIL',
                tabPanelItemId: 'APNSFASBursaryDetailitemId',
                tabPanelItemXtype: 'applicantnsfabursarydetailstructure',
                xtypeItemId: 'APNSFASbursarydetailstructure',
                render : true,
                defaultPanel: true
            }],

            'GENERAL': [/*{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'applicantDocumentDetails',
                tabPanelItemXtype: 'documentsearchpanel',
                xtypeItemId: 'applicantDocumentSearchPanel',
                defaultPanel: true
            	},*/  {
                tabPanelTitle: 'SERVICE_OPT_IN',
                tabPanelItemId: 'applicantServicesOptDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'applicantServiceOptGrid',
                defaultPanel: true
            },{
                tabPanelTitle: 'COMMUNITIES_OPT_IN',
                tabPanelItemId: 'applicantCommunityOptDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'applicantCommunityOptGrid',
                defaultPanel: true
            },/*{
            	 tabPanelTitle: 'CHEKLIST_ITEMS',
                 tabPanelItemId: 'applicantChecklistItem',
                 tabPanelItemXtype: 'cheklistitemgrid',
                 xtypeItemId: 'applicantCheckListGrid',
                 defaultPanel: true
            },*/{
	           	 tabPanelTitle: 'HOSTEL_PERSONAL_REQUIREMENTS',
	             tabPanelItemId: 'applicantPersonHostelRequirement',
	             tabPanelItemXtype: 'personhostelrequirementform',
	             xtypeItemId: 'applicantPersonHostelRequirementForm',
	             render: true,
	             defaultPanel: true
	        }],
            'APPOINTMENT_FOLLOWUP': [{
            	tabPanelTitle: 'MANAGE_APPOINTMENT',
            	tabPanelItemId: 'applicantAppointmentDetails',
            	tabPanelItemXtype: 'sgapplicantappointmentdetailstructure',
            	xtypeItemId: 'sgApplicantAppointmentGridStructureItemId',
            	//render : true,
            	defaultPanel: true
            },{
            	tabPanelTitle: 'MANAGE_FOLLOW_UP',
            	tabPanelItemId: 'applicantFollowupStructure',
            	tabPanelItemXtype: 'applicationfollowupstructure',
            	xtypeItemId: 'applicationfollowupstructureItemId',
            	render : true,
            	defaultPanel: true
            }],
            'DOCUMENT_HISTORY': [{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'applicantDocumentDetails',
                tabPanelItemXtype: 'documentsearchpanel',
                xtypeItemId: 'applicantDocumentSearchPanel',
                defaultPanel: true
            },{
            	tabPanelTitle: 'AD_HOC_DOCUMENTS',
                tabPanelItemId: 'adhocDocuments',
                tabPanelItemXtype: 'adhocdocumentgrid',
                xtypeItemId: 'adhocDocumentGridItemId',
                defaultPanel: true
            }/*,{
            	tabPanelTitle: 'DOC_ONLINE_DOCUMENTS',
            	tabPanelItemId: 'applicantOnlineDocuments',
            	tabPanelItemXtype: 'onlinedocumentgrid',
            	xtypeItemId: 'applicantOnlineDocumentGridItemId',
            	defaultPanel: true
            },{
            	tabPanelTitle: 'DOC_PHYSICAL_DOCUMENTS',
            	tabPanelItemId: 'applicantPhysicalDocuments',
            	tabPanelItemXtype: 'physicaldocumentgrid',
            	xtypeItemId: 'applicantPhysicalDocumentGridItemId',
            	defaultPanel: true
            }*/]

        };
        return applicantProfileLink ;
    },
    
    getOtherEmployeeProfileLink: function() {
        var otherEmployeeProfileLink = {
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: 'PERSONAL_DETAILS',
                tabPanelItemId: 'facultyPersonalDetails',
                tabPanelItemXtype: 'personalinformationform',
                xtypeItemId: 'facultyPersonalInformationForm',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'ADDRESSES',
                tabPanelItemId: 'facultyAddressDetails',
                tabPanelItemXtype: 'facultyaddressdetails',
                xtypeItemId: 'facultyAddressTemplate',
                render : true,
                defaultPanel: false
            }],

            'PAST_HISTORY': [{
                tabPanelTitle: 'EDUCATION',
                tabPanelItemId: 'facultyEducationHistoryDetails',
                tabPanelItemXtype: 'educationhistorygrid',
                xtypeItemId: 'facultyEducationHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'WORK_EXPERIENCE',
                tabPanelItemId: 'facultyWorkExperienceDetails',
                tabPanelItemXtype: 'workexperiencegrid',
                xtypeItemId: 'facultyWorkExperienceGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'MEDICAL_HISTORY',
                tabPanelItemId: 'facultyMedicalDetails',
                tabPanelItemXtype: 'medicalgrid',
                xtypeItemId: 'facultyMedicalGrid',
                render: true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'VACCINATION',
                tabPanelItemId: 'facultyVaccinationDetails',
                tabPanelItemXtype: 'vaccinationgridforapplicantfaculty',
                xtypeItemId: 'facultyVaccinationGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'EXTRA_CURRICULUM',
                tabPanelItemId: 'facultyExtraCurricularDetails',
                tabPanelItemXtype: 'extracurriculargrid',
                xtypeItemId: 'facultyExtraCurricularGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'RESEARCH_TYPE',
                tabPanelItemId: 'facultyResearchTypeDetails',
                tabPanelItemXtype: 'researchtypegrid',
                xtypeItemId: 'facultyResearchTypeGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'SEMINAR_DETAILS',
                tabPanelItemId: 'facultySeminarDetails',
                tabPanelItemXtype: 'seminardetailsgrid',
                xtypeItemId: 'facultySeminarDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'PATENT_DETAILS',
                tabPanelItemId: 'facultyPatentDetails',
                tabPanelItemXtype: 'patentdetailsgrid',
                xtypeItemId: 'facultyPatentDetailsGrid',
                render : true,
                defaultPanel: true
            },{
            	tabPanelTitle: 'TRAINING_DETAILS',
                tabPanelItemId: 'facultyTrainingPersonDetailsgrid',
                tabPanelItemXtype: 'trainingpersondetailsgrid',
                xtypeItemId: 'facultyTrainingPersonDetailsGrid',
                render : true,
                defaultPanel: true
            }/*{
                tabPanelTitle: 'QUALIFICATION_TYPE',
                tabPanelItemId: 'qualificationTypeDetail',
                tabPanelItemXtype: 'qualificationTypeDetailgrid',
                xtypeItemId: 'qualificationTypeDetailGrid',
                render : true,
                defaultPanel: true
            }*/],
            
            'COURSE_EXECUTION': [/*{
                tabPanelTitle: 'SCHEDULE',
                tabPanelItemId: 'facultyScheduleDetails',
                tabPanelItemXtype: 'scheduledetails',
                xtypeItemId: 'facultyScheduleCalender',
                render : true,
                defaultPanel: false
            },*/ {
                tabPanelTitle: 'ATTENDANCE',
                tabPanelItemId: 'facultyAttendanceDetailsTab',
                tabPanelItemXtype: 'facultyattendancedetails',
                xtypeItemId: 'facultyAttendanceDetails',
                render : true,
                defaultPanel: false
            }/*, {
                tabPanelTitle: 'PROGRAM_COURSES',
                tabPanelItemId: 'facultyProgramCoursesDetails',
                tabPanelItemXtype: 'programcoursesearchpanel',
                xtypeItemId: 'facultyProgramCourseSearchPanel',
                render : true,
                defaultPanel: false
            }*/],

            'SERVICES_COMMUNITIES': [{
                tabPanelTitle: 'SERVICES_HISTORY',
                tabPanelItemId: 'facultyServicesHistoryDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'facultyServiceHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'SERVICE_OPT_IN_OUT',
                tabPanelItemId: 'facultyServicesOptDetails',
                tabPanelItemXtype: 'serviceoptgrid',
                xtypeItemId: 'facultyServiceOptGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_HISTORY',
                tabPanelItemId: 'facultyCommunityHistoryDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'facultyCommunityHistoryGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'COMMUNITIES_OPT_IN_OUT',
                tabPanelItemId: 'facultyCommunityOptDetails',
                tabPanelItemXtype: 'communityoptgrid',
                xtypeItemId: 'facultyCommunityOptGrid',
                render : true,
                defaultPanel: true
            }],
            
            'REQUESTS': [{
                tabPanelTitle: 'REQUEST_RAISED_HISTORY',
                tabPanelItemId: 'facultyRequestRaisedHistoryDetails',
                tabPanelItemXtype: 'requestraisedhistorygrid',
                xtypeItemId: 'facultyRequestRaisedHistoryGrid',
                render : true,
                defaultPanel: true
            }, /*{
                tabPanelTitle: 'REQUEST_EXECUTED_HISTORY',
                tabPanelItemId: 'studentRequestExecutedHistoryDetails',
                tabPanelItemXtype: 'requestexecutedhistorygrid',
                xtypeItemId: 'facultyRequestExecutedHistoryGrid',
                render : true,
                defaultPanel: true
            },*/ {
                tabPanelTitle: 'REQUEST_PENDING_DESCISION',
                tabPanelItemId: 'studentRequestPendingDecisionDetails',
                tabPanelItemXtype: 'requestpendingdecisiongrid',
                xtypeItemId: 'facultyRequestPendingDecisionGrid',
                render : true,
                defaultPanel: true
            }/*, {
                tabPanelTitle: 'REQUEST_PENDING_ACTION',
                tabPanelItemId: 'studentRequestPendingActionDetails',
                tabPanelItemXtype: 'requestpendingactiongrid',
                xtypeItemId: 'facultyRequestPendingActionGrid',
                render : true,
                defaultPanel: true
            }*/],
            
            'PAYMENT_REFUND_HISTORY': [{
                tabPanelTitle: 'BILLS',
                //tabPanelTitle: 'PENDING_BILLS',
                tabPanelItemId: 'facultyPendingBillDetails',
                tabPanelItemXtype: 'pendingbillsgrid',
                xtypeItemId: 'facultyPendingBillsGrid',
                render : true,
                defaultPanel: true
            }, {
                //tabPanelTitle: 'PAYMENT_RECIEVED',
                tabPanelTitle: 'RECEIPTS',
                tabPanelItemId: 'facultyPaymentReceivedHistoryDetails',
                tabPanelItemXtype: 'paymentreceivedhistorygrid',
                xtypeItemId: 'facultyPaymentReceivedHistoryGrid',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: 'PAYMENT_MADE_HISTORY',
                tabPanelItemId: 'facultyPaymentMadeDetails',
                tabPanelItemXtype: 'paymentmadehistorygrid',
                xtypeItemId: 'facultyPaymentMadeGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'POST_DATED_CHEQUES',
                tabPanelItemId: 'facultyPostDatedChequeDetails',
                tabPanelItemXtype: 'postdatedchequegrid',
                xtypeItemId: 'facultyPostDatedChequeGrid',
                render : true,
                defaultPanel: true
            }],
            
            'DISCIPLINARY_ACTIVITY': [{
                tabPanelTitle: 'DISCIPLINARY_ACTIONS',
                tabPanelItemId: 'facultyDisciplinaryActionDetails',
                tabPanelItemXtype: 'disciplinaryactiongrid',
                xtypeItemId: 'facultyDisciplinaryActionGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'NEGATIVE_INCIDENTS',
                tabPanelItemId: 'otherEmployeeNegativeIncidentDetails',
                tabPanelItemXtype: 'negativeincidentgrid',
                xtypeItemId: 'otherEmployeeNegativeIncidentGrid',
                render : true,
                defaultPanel: true
            }, {
                tabPanelTitle: 'POSITIVE_INCIDENTS',
                tabPanelItemId: 'otherEmployeePositiveIncidentDetails',
                tabPanelItemXtype: 'positiveincidentgrid',
                xtypeItemId: 'otherEmployeePositiveIncidentGrid',
                render : true,
                defaultPanel: true
            }],

            'DOCUMENT_HISTORY': [{
                tabPanelTitle: 'DOCUMENTS',
                tabPanelItemId: 'otherEmployeeDocumentDetails',
                tabPanelItemXtype: 'documentgrid',
                xtypeItemId: 'otherEmployeeDocumentGrid',
                render : true,
                defaultPanel: true
            }]
        };
        return otherEmployeeProfileLink;
    },
});