/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.personinfo.common.course.FacultyDutyFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.facultydutyfilter',
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	items: [{
		xtype: 'form',
		plugins: "formlabelrequired",
		itemId: 'facultydutyformId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'role',
				itemId:'roleItemId',
				fieldLabel: getExaminationTranslation('ROLE'),
				store: 'examinationcenters.examstaffallocation.ExaminationRoles',
				displayField: 'value',
				valueField: 'id',
			forceSelection:true,
				typeAhead: true,	  
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'evaluationGroupId',
				itemId:'evaluationGroupItemId',
				store:'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('CNTRL_ERL_EVAL_GROUP'),
				disabled:true
			},{
				xtype: 'customcombobox',
				name: 'centerName',
				itemId: 'centerNameItemId',
				fieldLabel: getExaminationTranslation('CENTER_NAME'),
				store: 'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
				displayField: 'valueCode',
				valueField: 'id',
				typeAhead: true,
				disabled:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
    			xtype: 'customcombobox',
    			name:'programId',
    			itemId:'programIdItemId',
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter',
    			fieldLabel:getExaminationTranslation('PROGRAM'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'searchText',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			disabled:true,
    			hidden:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		},{
    			xtype: 'customcombobox',
    			name: 'batchId',
    			disabled:true,
    			hidden:true,
    			itemId:'batchIdItemId',
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter',
    			displayField:'value',
    			valueField:'id',
    			fieldLabel:getExaminationTranslation('BATCH'),
    			queryParam:'searchText',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			width:226,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		},{
    			xtype: 'customcombobox',
    			name: 'periodId',
    			itemId: 'periodItemId',
    			width:226,
    			fieldLabel:getExaminationTranslation('PERIOD'),
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
    			valueField: 'id',
//    			hidden:true,
    			displayField: 'value',
    			queryParam:'textSearch',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			disabled:true,
    			hidden:true,
    			width:226,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
    			xtype: 'customcombobox',
    			name:'courseId',
    			itemId:'courseIdItemId',
    			store: 'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
    			fieldLabel: getCommonTranslation('COURSE'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'searchText',
    			minChars:3,
    			typeAhead:false,
    			hidden:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			disabled:true,
    			hidden:true,
    			width:226,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		},{
				xtype: 'datefield',
				name: 'periodFrom',
				itemId:'periodFromItemId',
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'periodTill',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'dateTill',
				itemId:'periodTill',
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'periodFromItemId',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
        	xtype: 'fieldcontainer',
        	width: 'auto',

        	items: [{
        		xtype: 'button',
        		text: getCommonTranslation('SEARCH'),
        		itemId: 'searchBtn',
        		buttonAlign: 'left',
        		ui: 'CustomBtnSubmit',
        		scale: CONSTANTS.BUTTONSIZE,
        		formBind:true
        	},{
        		xtype: 'button',
        		text: getCommonTranslation('RESET'),
        		itemId: 'resetBtn',
        		ui: 'CustomBtnCancel',
        		scale: CONSTANTS.BUTTONSIZE   
        	}]	
        }]
	}]  
});