/**
 *  @author Amit G
 */

Ext.define('Academia.view.personinfo.common.course.VWLearningTargetMyCourseGradeTypeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vwlearningtargetmycoursegradetypegrid',
	frame:false,
	border:true,
	store:'personinfo.common.course.stoStudentMyCourseLearningTargetStore',
	autoScroll:false,
	title:getExaminationTranslation('LEARNING_TARGETS'),
	hidden: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype: 'button',
		itemId: 'btnPrintLearningPlan',
		text:getExaminationTranslation('PRINT_LEARNING_PLAN'),
		tooltip: getExaminationTranslation('PRINT_LEARNING_PLAN'),
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseName',
		flex : 1,    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			}                      
		}  
	},{
		   xtype: 'datecolumn',
		   header:getCommonTranslation('TARGET_DATE'),
		   dataIndex: 'targetDate',
		   flex:1,
		   dateFormat: 'Y-m-d',
		   editor: {
			   xtype: 'datefield',
			   allowBlank: true,
			   format: 'd/m/Y',
			   listeners: {
				   focus: function(field) {
					   if(!isNullOrEmpty(field.up('grid').getSelectionModel().getSelection()[0].data.targetDate)){
						   return field.setValue(new Date(field.up('grid').getSelectionModel().getSelection()[0].data.targetDate));
					   }
					   else{
						   return null;
					   }
				   }
			   }
		   },
		   renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			   var grid = view.up();
			   if (isNullOrEmpty(val)) {
				   rec.tdCls = 'gridInputCustomStyle';
				   return getExaminationTranslation('CLICK_TO_ENTER');
			   } else {
				   var store = grid.getStore();
				   var models = grid.getStore().getRange();
				   if (!isNullOrEmpty(val)) {

				   } else if (!isNullOrEmpty(record.data.dueDatePrefillValue)) {
					   val = record.data.dueDatePrefillValue;
				   }
				   models[rowIndex].set("targetDate", val);
				   return dateRender(val);
			   }
		   }
	   },{
		   xtype: 'datecolumn',
		   header:getCommonTranslation('LT_SUBMISSION_DATE'),
		   dataIndex: 'submissionDate',
		   flex:1,
		   dateFormat: 'Y-m-d',
		   editor: {
			   xtype: 'datefield',
			   allowBlank: true,
			   format: 'd/m/Y',
			   listeners: {
				   focus: function(field) {
					   if(!isNullOrEmpty(field.up('grid').getSelectionModel().getSelection()[0].data.submissionDate)){
						   return field.setValue(new Date(field.up('grid').getSelectionModel().getSelection()[0].data.submissionDate));
					   }
					   else{
						   return null;
					   }
				   }
			   }
		   },
		   renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			   var grid = view.up();
			   if (isNullOrEmpty(val)) {
				   rec.tdCls = 'gridInputCustomStyle';
				   return getExaminationTranslation('CLICK_TO_ENTER');
			   } else {
				   var store = grid.getStore();
				   var models = grid.getStore().getRange();
				   if (!isNullOrEmpty(val)) {

				   } else if (!isNullOrEmpty(record.data.dueDatePrefillValue)) {
					   val = record.data.dueDatePrefillValue;
				   }
				   models[rowIndex].set("submissionDate", val);
				   return dateRender(val);
			   }
		   }
	   },{
		header : getExaminationTranslation('TARGET_GRADE_MARK'),
		dataIndex : 'targetGradeMarks',
		flex : 1,
		editor : {
			xtype: 'customcombobox',
			name:'gradeMarkTarget',
			itemId:'gradeMarkTarget',
			store:Ext.create('Academia.store.gradeMaster.LearningTargerGradeStore'),
			displayField: 'gradeName',
	        valueField: 'gradeName',
	        editable: false
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getExaminationTranslation('GRADE_MARK_ACHIEVED'),
		dataIndex : 'obtainedGradeMarks',
		flex : 1,   
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			}                      
		}  
	},{ 
		header : getExaminationTranslation('TARGET_ATTENDANCE'),
		dataIndex : 'targetAttendance',
		flex : 1,
		editor: {
			xtype: 'numberfield',
			name: 'targetAttendance',
			itemId:'targetAttendance',
			editable:true,
			maxValue:100,
			listeners:{
	        	blur: function(obj, record){
	        		if(obj.getValue()>=0){
	        			obj.up('vwmycoursedetailslearningtargets').down('#learningTargetSubmit').setDisabled(false);
	        			return obj.getValue();
	        		} else {
	        			obj.up('vwmycoursedetailslearningtargets').down('#learningTargetSubmit').setDisabled(true);
	        			return 0;
	        		}
	        	}
	        }
		},    
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getExaminationTranslation('ATTENDANCE_ACHIEVED'),
		dataIndex : 'obtainedAttendance',
		flex : 1,    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			}                      
		}  	  
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(ed,e){
				var grid = Ext.ComponentQuery.query('vwlearningtargetmycoursegradetypegrid')[0];
				var userModel=Academia.model.authentication.UserInfoModel;
				if(userModel.get("portalId")==1 || userModel.get("portalId")==2){
					if(ed.context.field=='targetDate'){
						var selectedRecord = grid.getSelectionModel().getSelection()[0];
						var periodStartDate=selectedRecord.data.periodStartDate;
						var periodEndDate=selectedRecord.data.periodEndDate;
						ed.context.column.field.setMinValue(dateRender(periodStartDate));
						var parseEndDate=new Date(periodEndDate);
						var parseTargetDate=new Date(selectedRecord.data.targetDate);
						ed.context.column.field.setMaxValue(parseEndDate);
					} else if (ed.context.field=='submissionDate'){
						var selectedRecord = grid.getSelectionModel().getSelection()[0];
						var periodStartDate=selectedRecord.data.periodStartDate;
						var periodEndDate=selectedRecord.data.periodEndDate;
						ed.context.column.field.setMinValue(dateRender(periodStartDate));
						var parseEndDate=new Date(periodEndDate);
						var parseTargetDate=new Date(selectedRecord.data.targetDate);
					}
				} else {
					if(ed.context.field=='targetDate' || ed.context.field=='submissionDate'){
						ed.context.column.field.setReadOnly(true);
					} 
				} 
				grid.getSelectionModel().deselectAll();
			}
        }
	}]
});