/**
 *  Disciplinary Action Grid
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.disciplinaryactiongrid',
    title: getPersonModuleTranslation('DISCIPLINARY_ACTION'),
    border: true,
    overflowX: false,
    overflowY: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnAddStudents',
        text: getCommonTranslation('ADD_STUDENTS'),
        tooltip: getCommonTranslation('ADD_STUDENTS'),
        disabled: true
    }],
    columns: [{
        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
        dataIndex: 'incidentType',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value; 
			}                        
		}
    },  {
        header: getPersonModuleTranslation('DATE_OF_INCIDENT'),
        dataIndex: 'studentIncidentDate',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
        dataIndex: 'details',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('REPORTER_USER_NAME'),
        dataIndex: 'reportedByUserName',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('ACTION_TAKEN'),
        dataIndex: 'actionTaken',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DATE_OF_ACTION'),
        dataIndex: 'studentDateOfAction',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('EMPLOYEES_INVOLVED'),
        itemId: 'employeesInvolvedItemId',
        dataIndex: 'disciplinaryActionDetails',
        sortable: true,
        flex: .25,
		renderer:function(value, meta, record){
			var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
			var portalId = baseController.getCurrentLoggedPortalId();
			if(!isNullOrEmpty(value) && portalId!=3 && portalId!=7) {	
				if(record.data.disciplinaryActionDetails.length){
					return '<a href=#>'+record.data.disciplinaryActionDetails.length+'<a>';
				}
			}else if(!isNullOrEmpty(value)){
				if(record.data.disciplinaryActionDetails.length){
					return record.data.disciplinaryActionDetails.length;
				}
			}
			return '';
		}
    }, {
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    }, {
		header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>1) {					
					return '<a href=#>'+record.data.documents.length+'<a>';
				} else if(record.data.documents.length==1) {
					return '<a href=#>'+record.data.documents[0].name+'<a>';
				} 
			}                        
		}
	}],
    listeners: {
        selectionchange: {
            fn: function(model, selected) {
                model.view.up().down('#btnAddStudents').setDisabled(!selected.length);
            },
            scope: this
        },
        afterrender: function(grid){
        	try{
        		setTimeout(function(){
        			var employeesInvolvedItemId = grid.down('#employeesInvolvedItemId');
        			var index = employeesInvolvedItemId.getIndex();
        			if(grid.itemId=="studentDisciplinaryActionGrid"){
        				grid.columns[index].setText(getCommonTranslation('STUDENTS_INVOLVED'));
        				grid.getView().refresh();
        			} else {
        				grid.columns[index].setText(getCommonTranslation('EMPLOYEES_INVOLVED'));
        				grid.getView().refresh();
        			}
        		},300);
        	}
        	catch(e){
        		console.log("");
        	}
        }
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
                       
         this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.disciplinaryactivity.DisciplinaryActionStore');
    }

});