/**
 * @author prakash sharma
 */
Ext.define('Academia.view.personinfo.common.documentrequested.ApplicantDocumentRequestedGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicantdocumentrequestedgrid',
    title: getPersonModuleTranslation('DOCUMENT_REQUEST'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns : [{
		text : getCommonTranslation('DOCUMENT_GROUP'),
		dataIndex: 'groupName',
		sortable : false,
		flex:0.3,
		renderer: function(value, metadata, record) {
			return '<a href="#">' +record.data.groupName+'</a>';
		}
	}, {
		text : getCommonTranslation('REQUESTED_ON'),
		dataIndex : 'requestedOn',
		sortable : false,
		flex:0.3,
		renderer: function(value){
			return dateRender(value);
		}
	}, {
		text : getCommonTranslation('SUBMISSION_LAST_DATE'),
		dataIndex : 'dueOn',
		sortable :false,
		flex:0.2,
		renderer: function(value){
			return dateRender(value);
		}
	},  {
		text : getCommonTranslation('STATUS'),
		dataIndex: 'documentStatus',
		sortable : false,
		flex:0.2,
		renderer : function(value) {
			var val = '';
			if(value == 'Completed') {
				val = '<span style="color:Green;">' +'Completed'+ '</span>';
			}else if(value == 'Pending') {
				val = '<span style="color:red;">' +'Pending'+ '</span>';
			}else if(value == 'Partially Completed') {
				val = '<span style="color:orange;">' +'Partially Uploaded'+ '</span>';
			}
			return val;
		}

	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store:store ,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
       // this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.common.documentRequstedByPersonId');
    }

});
