/**
 * @author sachin.bangar
 * Education History Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.EducationForm', {
    //extend: 'Academia.view.common.CustomFieldForm',
    extend:'Academia.view.common.IdGeneratorCustomForm',
	//extend:'Ext.form.Panel',
	alias: 'widget.educationform',
    border : false,
    frame : false,
    addPosition: 3,
    //customFieldEntity:CONSTANTS.APPLICANT_EDUCATION_CF_DATA,
    //columns: 1,
    plugins: "formlabelrequired",
    initComponent: function() {
		if(this.itemId==='applicantEducationForm'){
		    Ext.apply(this,{
		          customFieldEntity:CONSTANTS.APPLICANT_EDUCATION_CF_DATA,
                  columns: 2
		    });
		   
		}else{
			Ext.apply(this,{
		          customFieldEntity:CONSTANTS.EDUCATION_HISTORY_CD,
                columns: 2
			});
		}
		this.callParent(arguments);
},/*
    initComponent: function(){
        console.log(this);
        if(this.itemId==='applicantEducationForm'){
            console.log('this.itemId');
        }else{
            console.log('this.itemId');
        }
        Ext.apply(this,{
            customFieldEntity:CONSTANTS.APPLICANT_EDUCATION_CF_DATA,
        columns: 1
        });
    },*/
    items: [{
        xtype: 'hidden',
        itemId: 'education_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
    	xtype:'hidden',
    	name:'marksOrGradeObtained'
    },{
    	xtype:'hidden',
    	itemId: 'isMarkGradVisible',
    	name:'isMarkGradVisible'
    },{
    	xtype:'hidden',
    	itemId: 'isAssessmentLevelVisible',
    	name:'isAssessmentLevelVisible'
    },{
        xtype: 'hidden',
        itemId:'filePath',
        name: 'filePath'
    },{
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	},{
		xtype:'hidden',
    	itemId: 'minimumSubject',
    	name:'minimumSubject'
    },{
    	xtype:'hidden',
    	itemId: 'maximumSubject',
    	name:'maximumSubject'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            itemId: 'examPassed',
            fieldLabel: getPersonModuleTranslation('EXAM_PASSED'),
            store: 'common.ExamPassedStore',
            valueField: 'id',
            displayField: 'value',
            name: 'examPassed',
            editable : false,
            allowBlank:false,
            hideTrigger:false,
            triggerAction: 'all',
            forceSelection:true
        },{
        	xtype: 'nestedJsonCombo',
            itemId: 'examBoard',
            fieldLabel: getPersonModuleTranslation('EXAM_BOARD'),
            store: 'common.ExamBoardStore',
            valueField: 'id',
            displayField: 'value',
            name: 'examBoard',
            editable : false,
            allowBlank:true,
            hideTrigger:false,
            triggerAction: 'all',
            forceSelection:true
        },{
        	 xtype: 'textfield',
             fieldLabel: getPersonModuleTranslation('EXAM_CONDUCTED_BY_COLLAGE'),
             name: 'examConductedBy',
             allowBlank:true,
             width: 230,
             maxLength:25,
             disabled:true,
             itemId: 'examConductedById'
        },{
        	  xtype: 'nestedJsonCombo',
	       	 name: 'educationDepartment',
	       	 itemId: 'educationDepartmentId',
	       	 store: Ext.create('Academia.store.enquiry.EducationDepartmentStore'),
	       	 fieldLabel: getEnquiryTranslation('EDUCATION_DEPARTMENT'),
	       	 valueField: 'id',
	       	 displayField: 'value',
	       	 editable: false,
	       	 allowBlank: true,
	       	 typeAhead: true,
	       	 forceSelection: true
		}]
    },{
   	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 226
     },
     items: [{
	    	 	xtype: 'nestedJsonCombo',
				name: 'country',
				itemId: 'countryItemId',
				fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
				store: Ext.create('Academia.store.common.CountryStore'),
				valueField: 'id',
				displayField: 'countryName',
				editable:false,
				forceSelection:true
     		},{
    			xtype : 'nestedJsonCombo',
    			fieldLabel : getCommonTranslation('COUNTRY_REGION'),
    			itemId : 'countryRegionItemId',
    			store:Ext.create('Academia.store.organization.CountryRegionStore'),
    			valueField : 'id',
    			displayField : 'countryRegionName',
    			name : 'countryRegion',
    			editable : false,
    			forceSelection :true,
    			width: 226,
    			disabled:true
    		},{
    			xtype: 'nestedJsonCombo',
    			fieldLabel: getCommonTranslation('ADDRESS_CITY'),
    			name: 'city',
    			editable: false,
    			itemId: 'cityItemId',
    			store: Ext.create('Academia.store.organization.CityByCountryRegion'),
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection :true,
    			width: 226,
    			disabled:true
    		}]
    },{
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 226
         },
         items: [{
        	xtype: 'nestedJsonCombo',
        	name: 'campaignSchool',
			itemId: 'campaignSchoolId',
            fieldLabel: getCommonTranslation('SCHOOL_NAME'),
            store: Ext.create('Academia.store.campaignnew.CampaignSchoolDependencyStore'),
            valueField: 'id',
            displayField: 'value',
            editable : false,
            allowBlank:true,
            hideTrigger:false,
            hidden:true,
            triggerAction: 'all',
            forceSelection:true,
            disabled:true,
        },{
         	 xtype: 'textfield',
              fieldLabel: getPersonModuleTranslation('INSTITUTE_NAME'),
              name: 'instituteName',
              allowBlank:false,
              width: 226,
              maxLength:255,
              disabled:false,
              itemId: 'instituteNameId',
         },{
         	 xtype: 'textfield',
             fieldLabel: getPersonModuleTranslation('PLACE'),
             name: 'place',
             itemId: 'place',
             maxLength:150,
             width: 226
        }]
    },{
   	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 226
     },
     items: [{
     	 xtype: 'textfield',
          fieldLabel: getPersonModuleTranslation('ENROLLMENT_NUMBER'),
          name: 'enrollmentNumber',
          itemId: 'enrollmentNumber',
          maxLength:25,  
          maskRe:/^([a-zA-Z0-9/ -]+?)*$/
              // vtype:'NoSpecialCharactersWithNumberWithoutSpaceAsInput',
     },{
    	 xtype: 'nestedJsonCombo',
         itemId: 'studyMode',
         fieldLabel: getPersonModuleTranslation('MODE_OF_STUDY'),
         store: 'admission.applications.history.StudyModes',
         valueField: 'id',
         displayField: 'value',
         name: 'studyMode',
         editable : false
     },{
    	 xtype: 'nestedJsonCombo',
         itemId: 'mediumOfInstruction',
         fieldLabel: getPersonModuleTranslation('MEDIUM_OF_INSTRUCTIONS'),
         store: 'admission.applications.history.MediumOfInstructionsStore',
         valueField: 'id',
         displayField: 'value',
         name: 'mediumOfInstruction',
         editable : false
     }]
    },{

      	 xtype: 'fieldcontainer',
           layout: 'hbox',
           defaults: {
               labelAlign: 'top',
               width: 226
           },
           items: [{
          	 xtype: 'datefield',
          	 name: 'yearOfExam',
          	 itemId:'yearOfExam',
          	 vtype: 'daterange',
          	 editable:false,
          	 fieldLabel: getCommonTranslation('DATE_OF_EXAM'),
          	listeners: {
         		 render: function(field) {
         			 return dateFormatRender(field);
         		 }
         	 }
           },{
               xtype: 'customcombobox',
               fieldLabel: getCommonTranslation('MONTH_OF_EXAM'),
               name: 'monthOfExamination',
               itemId: 'monthItemId',
               editable: false,
               store: 'personinfo.common.pasthistory.ApplicantEducationMonthStore',
               displayField: 'value',
               valueField: 'code',
               queryMode: 'local',
               labelAlign: 'top',
               width: 226
       },{
           xtype: 'customcombobox',
           fieldLabel: getCommonTranslation('YEAR_OF_EXAM'),
           name: 'yearOfExamination',
           itemId: 'yearItemId',
           editable: false,
           store: 'personinfo.common.pasthistory.ApplicantEducationYearStore',
           displayField: 'value',
           valueField: 'id',
           queryMode: 'local',
           labelAlign: 'top',
           width: 226
       }]
      
       }, {
           xtype: 'fieldcontainer',
           layout: 'hbox',
           itemId:'marksgradecontainerId',
           defaults: {
               labelAlign: 'top',
               width: 226,
           },
           items: [{
               xtype: 'customcombobox',
               itemId: 'gradeMark',
               store: 'admission.applications.history.EducationGradAndMarks',
               fieldLabel: getPersonModuleTranslation('GRADE_MARKS'),
               name: 'gradeMark',
               valueField: 'id',
               displayField: 'value',
               editable : false
           }, {
               xtype: 'textfield',
               fieldLabel: getPersonModuleTranslation('GRADE_OBTAINED'),
               itemId: 'gradeObtained',
               maxLength:20,
               name: 'gradeObtained'
           },{
           	 xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('MARKS_OBTAINED'),
                itemId: 'marksObtained',
                name: 'marksObtained',
                hidden:true,
                width: 109,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                hideTrigger: true,
                maxLength:20,
                minValue:0
           },{
           	 xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('MAXIMUM_MARKS'),
                itemId: 'maximumMarks',
                name: 'maximumMarks',
                hidden:true,
                width: 113,
                maxLength:5,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                hideTrigger: true,
                minValue:0,
                listeners: {
               	 change: function(obj, eOpts) {
               		 this.previousSibling().setMaxValue(obj.getValue());
               		 this.previousSibling().validate();
               	 }
                }
           }, {
           	 xtype: 'numberfield',
           	 fieldLabel: getPersonModuleTranslation('GPA/Percentage'),
                itemId: 'percentage',
                name: 'percentage',
                hideTrigger: true,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                maxLength:45,
                allowExponential: false,
                minValue:0
           }]
       },{
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 226
         },
         items: [{
        	 xtype: 'textfield',
             fieldLabel: getPersonModuleTranslation('SPECIALIZATION'),
             itemId: 'specialization',
             maxLength:100,
             name: 'specialization'
         },{
             xtype: 'nestedJsonCombo',
             fieldLabel: getPersonModuleTranslation('RESULT_STATUS'),
             itemId:'resultStatusId',
             store:'admission.applications.history.ResultStatus',
             name: 'resultStatus',
             //V2D-106123
//           allowBlank:false,
             editable : false,
             displayField:'value',
     		 valueField:'id'
         },{
         	 xtype: 'textfield',
             fieldLabel: getPersonModuleTranslation('RESULT_CAPTURE_MODE'),
             name: 'resultCapturingMode',
             itemId: 'resultCapturingMode',
			 readOnly: true,
             width: 226
        }]
    }, {
        xtype: 'panel',
        itemId: 'subjectMarkPanel',
        margin: '0px',
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox',
                align: 'bottom'
            },
            items: [{
                xtype: 'hidden',
                itemId: 'subjectId',
                name: 'subjectId'
            }, {
                xtype: 'hidden',
                itemId: 'subjectVersion',
                name: 'subjectVersion'
            }, {
                xtype: 'customcombobox',
                itemId: 'subject',
                fieldLabel: getPersonModuleTranslation('SUBJECT'),
                labelAlign: 'top',
                width: 226,
                valueField: 'id',
                displayField: 'value',
                name: 'subject',
                store:'common.EducationHistorySubjectStore',
              //  editable : false,
                rowIndx:0,
                typeAhead:false,
                queryParam:'qry',
                    minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                listConfig: {
                    listeners: {
                    	beforeshow: function(picker) {
                    	picker.minWidth = picker.up('combobox').getSize().width;
                    		}
                    	},
                  loadingText: getCommonTranslation('SEARCHING'),
                   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                    	 return '<div class="search-item">' +
                    	           '{value}' +
                    	           '</div>';
                    	  }
                 },
            },{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('OTHER_SUBJECT'),
                labelAlign: 'top',
                name: 'otherSubject',
                itemId: 'otherSubject',
                maxLength:150,
                hidden:true,
                width: 113
            },{
            	xtype: 'numberfield',
            	fieldLabel: getPersonModuleTranslation('MAXIMUM_MARKS'),
            	labelAlign: 'top',
            	itemId: 'subMaximumMarks',
            	name: 'subMaximumMarks',
            	disabled: true,
            	width: 113,
            	maxLength:5,
            	keyNavEnabled: false,
            	mouseWheelEnabled: false,
            	hideTrigger: true,
            	minValue:0,
            	validator: function(value){
                	var res = true;
                	var maxMarkvalidText = null;
                	if(this.nextSibling().isHidden()){
                		if(!isNullOrEmpty(this.nextSibling().nextSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()<this.nextSibling().nextSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                        if(res) {
                            return true;
                        } else {
                        	if(!isNullOrEmpty(maxMarkvalidText)){
                        		return maxMarkvalidText;	
                        	}
                        }
                	}else{
                		return true;
                	}
                }
            }, {
            	xtype: 'nestedJsonCombo',
                itemId: 'assessmentLevelItemId',
                fieldLabel: getPersonModuleTranslation('ASSESSMENT_LEVEL'),
                labelAlign: 'top',
                width: 113,
                valueField: 'value',
                displayField: 'value',
                name: 'assessmentLevel',
                hidden:true,
                disabled: true,
                store: Ext.create('Academia.store.common.AssessmentLevelStore'),
                editable : false
            }, {
                xtype: 'nestedJsonCombo',
                itemId: 'markGradItemId',
                fieldLabel: getPersonModuleTranslation('MARKS_GRADE'),
                labelAlign: 'top',
                width: 113,
                valueField: 'id',
                disabled: true,
                displayField: 'value',
                name: 'conversionMaster',
                hidden:true,
                store:Ext.create('Academia.store.common.EducationHistoryGradeStore'),
                editable : false
            } ,{
                xtype: 'textfield',
                itemId: 'marks',
                fieldLabel: getPersonModuleTranslation('EQUIVALENT_MARKS_GRADE'),
                labelAlign: 'top',
                width: 113,
                disabled: true,
                name: 'marks',
                maxLength:7,
                decimalPrecision:2,
                validator: function(value){
                	var validText = getPersonModuleTranslation('MARKS_GRADE_VALID_TYPE');
                	var patt = new RegExp('(^[A-Z]{1}[+]{1}$)|(^[A-Z]{1}[+]{2}$)|(^[A-Z]{1}[-]{1}$)|(^[A-Z]{1}[-]{2}$)|(^[A-Z]{1}[0-9]{1}$)|(^[A-Z]{1}$)|(^[0-9]{1,3}$)|(^[0-9]{1,3}[\.]{1}[0-9]{1,5}$)');
                	var res = patt.test(value);
                	var maxMarkvalidText = null;
                	if(this.previousSibling().isHidden()){
                		if(!isNullOrEmpty(this.previousSibling().previousSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()>this.previousSibling().previousSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                	}
                    if(res) {
                        return true;
                    } else {
                    	if(!isNullOrEmpty(maxMarkvalidText)){
                    		return maxMarkvalidText;	
                    	}else{
                    		return validText;
                    	}
                    }
                }
            },{
            	xtype: 'textfield',
                fieldLabel: getCommonTranslation('SYMBOL_LEVEL'),
                labelAlign: 'top',
                name: 'symbolLevel',
                itemId: 'symbolLevelId',
                disabled: true,
                width: 113,
                maxLength:1,
            },{
            	xtype: 'numberfield',
                fieldLabel: getCommonTranslation('PERCENTAGE'),
                labelAlign: 'top',
                name: 'percent',
                itemId: 'percentageId',
                disabled: true,
                width: 113,
                minLength:0,
                maxLength:5,
                hideTrigger: true,          
                keyNavEnabled: false,       
                mouseWheelEnabled: false,   
                allowExponential: false
            },/* {
        		xtype : 'button',
        		itemId: 'btnDeleteSubjectMarks0',
        		glyph: ICONGLYPH.DELETEGLYPH,
	   			cls: 'CustomBodyBtnReject',
	   			tooltip: getCommonTranslation('DELETETOOLTIP')
        	},*/ {
        		xtype : 'button',
        		itemId: 'btnAddSubjectMarks0',
        		cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
        	}]
        }]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	items: [{
    		xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('PASS_TYPE'),
            name: 'passType',
            itemId: 'passTypeItemId',
            store: 'personinfo.common.pasthistory.ApplicantPassTypeStore',
            displayField: 'value',
            valueField: 'id',
            labelAlign: 'top',
            width: 226,
            hidden: true,
            typeAhead:false,
            forceSelection:true,
            editable: false
    	},{
    		 xtype: 'numberfield',
             fieldLabel: getCommonTranslation('YEAR_CURRENT_LAST_SCHOOL_ATTENDED'),
             name: 'startYearCurrentOrLastSchoolAttended',
             itemId: 'yearCurrentLastSchoolAttendedId',
             width: 230,
             minLength:4,
             maxLength:4,
             hidden: true,
             hideTrigger: true,          
             keyNavEnabled: false,       
             mouseWheelEnabled: false,   
             allowDecimals: false,       
             allowExponential: false
    	},{
    		 xtype: 'numberfield',
             fieldLabel: getCommonTranslation('START_YEAR_WHERE_HIGHEST_QUALIFICATION'),
             name: 'startYearAtSchoolHighestQaulificatioAttended',
             itemId: 'startYearOFHighestQualificationId',
             width: 230,
             minLength:4,
             maxLength:4,
             hidden: true,
             hideTrigger: true,          
             keyNavEnabled: false,       
             mouseWheelEnabled: false,   
             allowDecimals: false,       
             allowExponential: false
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	items: [{
    		xtype      : 'radiogroup',
    		fieldLabel : getCommonTranslation('REPEATED_SCHOOL_SUBJECTS'),
    		itemId: 'educationRepeatedSubjectId',
    		name: 'educationRepeatedSubject',
    		height : 55,
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'isRepeatedSubject', 
    			inputValue: true
    			
    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'isRepeatedSubject', 
    			inputValue: false,
    			checked:true

    		}]
    	},{
    		xtype: 'filefield',
    		fieldLabel: getCommonTranslation('UPLOAD_FILE'),
    		buttonText: getCommonTranslation('UPLOAD'),
    		itemId: 'uploadFileItemId',
    		ui: 'CustomBtnSubmit',
    		name: 'file',
    		hidden:true,
    		width: 226,
    		labelAlign: 'top',
    		listeners: {
    			specialkey: function(me, e) {
    				if (e.getKey() == e.TAB) {
    					e.stopEvent();
    				}
    			}
    		}
    	},
    	  	{
			xtype: 'displayfield',
			itemId: 'educationDownloadURL',
			style:{'margin-top':'25px'},
			name:'filePath',
			width: 460,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(){
	    				var path = this.up('educationform').down('#educationDownloadURL').getValue();
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    				if (!isNullOrEmpty(path)) {
	    					csvForm.getForm().submit({
								   target: '_blank',
								   method:'POST',
								   params :{
									   access_token : Ext.Ajax.defaultHeaders.access_token,
									   path: path
								   },
								   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
								   standardSubmit :true
							   });
						}
	    			}, c);
	    		}
	    	}
			}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	items: [{
    		xtype      : 'radiogroup',
    		fieldLabel : getCommonTranslation('PASS_MATRICULATION_EXEMPTION'),
    		itemId: 'passMatriculationExemptionId',
    		name: 'isPassMatriculationExemption',
    		height : 55,
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'isPassMatriculationExemption', 
    			inputValue: true

    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'isPassMatriculationExemption', 
    			inputValue: false,
    			checked:true

    		}]
    	}]
    },

    {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 460
    	},
    	items: [{
    		xtype: 'textarea',
    		fieldLabel: getPersonModuleTranslation('REMARKS'),
    		name: 'remarks'
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE

    	}]
    }]
});
