/**
 * @author sachin.bangar
 * Medical History Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ExtraCurricularForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.extracurricularform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'curricular_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },/*{
        xtype: 'hidden',
        name: 'eventId'
    },*/ {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			name: 'eventId',
			fieldLabel: getServiceRequestTranslation('EVENT_NAME'),
			itemId:'eventId',
			store:'facilitiesresources.resourcebooking.EventNameListStore',
			displayField:'value',
			valueField:'id',
			width:226,
			hidden:true
		},{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('EVENT_NAME'),
            name: 'otherEvent',
            itemId : 'otherEventId',
            maxLength: 45
            //allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ACTIVITY_NAME'),
            name: 'activityName',
            itemId : 'activityNameId',
            allowBlank: false
        },{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('ACTIVITY_TYPE'),
            name: 'activityType',
            itemId:'activityType',
            valueField: 'id',
            displayField: 'value',
            store: 'personinfo.common.pasthistory.ActivityTypeStore',
            editable: false,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('CONDUCT_ORGANIZATION'),
            itemId:'organization',
            name: 'organization',
            allowBlank: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('COMMUNITY_NAME'),
            allowBlank: true,
            name: 'community',
            itemId:'community',
            valueField: 'id',
            displayField: 'value',
            store: 'personinfo.common.services.CommunityNameStore',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AWARD_RECIEVED'),
            name: 'performance',
            itemId:'performance',
            //allowBlank: false
        },{
            /*xtype: 'numberfield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_RECIEPT'),
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            name: 'activityYear',
            allowBlank: false,
            listeners: {
                afterrender: function(yearNumber, eOpts) {
                    var year = new Date().getFullYear();
                    yearNumber.setMaxValue(year);
                }
            }*/
        
	        xtype: 'datefield',
			name: 'awardDate',
			itemId:'awardDate',
			fieldLabel: getPersonModuleTranslation('AWARD_DATE'),
			//allowBlank:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			editable:true,
			maxValue:new Date(),
        
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'fit',
        autoHeight: true,
        items: [{
            xtype: 'radiogroup',
            fieldLabel: getPersonModuleTranslation('EVENT_HELD'),
            itemId : 'isCurrentOrgRadioGroup',
            name: 'isCurrentOrganization',
            columns: 2,
            vertical: true,
            items: [{
                boxLabel: getPersonModuleTranslation('BEFORE_JOINING'),
                name: 'isCurrentOrganization',
                itemId : 'previousOrgRadioBtn',
                inputValue: false,
                checked : true
            }, {
                boxLabel: getPersonModuleTranslation('AFTER_JOINING'),
                itemId : 'currentOrgRadioBtn',
                name: 'isCurrentOrganization',
                inputValue: true
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width : 460
        },
        items: [{
            xtype: 'textareafield',
            name: 'remarks',
            itemId: 'remarks',
            fieldLabel: getPersonModuleTranslation('REMARK')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});