/**
 * @author Ameesha Namdev
 *
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentHealthInformationDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studenthealthinformationdocumentgrid',
    store : 'personinfo.common.pasthistory.StudentHealthInformationDocumentGridStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		sortable:false,
		renderer:function(value, metaData, record){
		if(record){
			var pathSplit=record.data.path.split('/');
            var newPath=pathSplit[2];
			var newvalue=!isNullOrEmpty(value)?value:newPath;
			return "<a href='#'>"+newvalue+"</a>";
		}
		}
	}]
});