/**
 * @Author Ameesha Namdev
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentHealthInformationForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studenthealthinformationform',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'health_information_Details_hidden_field',
        name: 'id'
    }, {
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 260
         },
         items: [{
        	 xtype: 'multiselectcombofield',
        	             fieldLabel: getCommonTranslation('MEDICAL_CONDITIONS'),
        	             name: 'medicalConditions',
        	             itemId: 'medicalConditionsItemId',
        	             store:'common.MedicalConditionCSMStore',
        	             displayField: 'value',
        	             valueField: 'id',
        	             width: 260,
        	             allowBlank:true,
        	             //queryMode: 'remote',
        	             typeAhead : true,
        	             forceSelection:true,
        	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
        	             enableKeyEvents: 'true',
        	             hideTrigger: false,
        	             listConfig: {
        	                 listeners: {
        	                     beforeshow: function(picker) {
        	                         picker.minWidth = picker.up('combobox').getSize().width;
        	                     }
        	                 },
        	                 loadingText: getCommonTranslation('SEARCHING'),
        	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	                 getInnerTpl: function() {
        	                     return '<div class="search-item">' +
        	                     '{value}' +
        	                     '</div>';
        	                 }
        	             }
        	 
 		},{
             xtype: 'textfield',
             fieldLabel: getCommonTranslation('MEDICAL_CONDITIONS_NAME'),
             itemId : "medicalConditionName",
             name: 'medicalConditionName',
             allowBlank: true,
             maxLength:255,
             disabled:true,
             hidden:true
		},]
    } ,{
   	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 260
     },
     items: [{
    	 xtype: 'multiselectcombofield',
    	             fieldLabel: getCommonTranslation('MEDICATION'),
    	             name: 'medication',
    	             itemId: 'medicationItemId',
    	             store:'common.MedicationCSMStore',
    	             displayField: 'value',
    	             valueField: 'id',
    	             width: 260,
    	             allowBlank:true,
    	             //queryMode: 'remote',
    	             typeAhead : true,
    	             forceSelection:true,
    	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    	             enableKeyEvents: 'true',
    	             hideTrigger: false,
    	             listConfig: {
    	                 listeners: {
    	                     beforeshow: function(picker) {
    	                         picker.minWidth = picker.up('combobox').getSize().width;
    	                     }
    	                 },
    	                 loadingText: getCommonTranslation('SEARCHING'),
    	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                 getInnerTpl: function() {
    	                     return '<div class="search-item">' +
    	                     '{value}' +
    	                     '</div>';
    	                 }
    	             }
		},{
         xtype: 'textfield',
         fieldLabel: getCommonTranslation('MEDICATION_NAME'),
         itemId : "medicationName",
         name: 'medicationName',
         allowBlank: true,
         maxLength:255,
         disabled:true,
         hidden:true
	},]
},{
	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 260
     },
     items: [{
    	 xtype: 'multiselectcombofield',
    	             fieldLabel: getCommonTranslation('ALLERGIES'),
    	             name: 'allergies',
    	             itemId: 'allergiesItemId',
    	             store:'common.AllergiesCSMStore',
    	             displayField: 'value',
    	             valueField: 'id',
    	             width: 260,
    	             allowBlank:true,
    	             //queryMode: 'remote',
    	             typeAhead : true,
    	             forceSelection:true,
    	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    	             enableKeyEvents: 'true',
    	             hideTrigger: false,
    	             listConfig: {
    	                 listeners: {
    	                     beforeshow: function(picker) {
    	                         picker.minWidth = picker.up('combobox').getSize().width;
    	                     }
    	                 },
    	                 loadingText: getCommonTranslation('SEARCHING'),
    	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                 getInnerTpl: function() {
    	                     return '<div class="search-item">' +
    	                     '{value}' +
    	                     '</div>';
    	                 }
    	             }
		}
    
     ,{
         xtype: 'textfield',
         fieldLabel: getCommonTranslation('ALLERGIES_NAME'),
         itemId : "allergiesName",
         name: 'allergiesName',
         allowBlank: true,
         maxLength:255,
         disabled:true,
         hidden:true
	},]
},{
	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 260
     },
     items: [{
    	 xtype: 'multiselectcombofield',
    	             fieldLabel: getCommonTranslation('LEARNING_DIFFICULTIES'),
    	             name: 'learningDifficulties',
    	             itemId: 'learningDifficultiesItemId',
    	             store:'common.LearningDifficultiesCSMStore',
    	             displayField: 'value',
    	             valueField: 'id',
    	             width: 260,
    	             allowBlank:true,
    	             //queryMode: 'remote',
    	             typeAhead : true,
    	             forceSelection:true,
    	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    	             enableKeyEvents: 'true',
    	             hideTrigger: false,
    	             listConfig: {
    	                 listeners: {
    	                     beforeshow: function(picker) {
    	                         picker.minWidth = picker.up('combobox').getSize().width;
    	                     }
    	                 },
    	                 loadingText: getCommonTranslation('SEARCHING'),
    	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                 getInnerTpl: function() {
    	                     return '<div class="search-item">' +
    	                     '{value}' +
    	                     '</div>';
    	                 }
    	             }
     }
		,{
         xtype: 'textfield',
         fieldLabel: getCommonTranslation('LEARNING_DIFFICULTIES_NAME'),
         itemId : "learningDifficultiesName",
         name: 'learningDifficultiesName',
         allowBlank: true,
         maxLength:255,
         disabled:true,
         hidden:true
	},]
},{
	xtype: 'fieldcontainer',    
	layout : {
		type : 'vbox'
	},
	cls:'horizontal-scrolling-fix',
	defaults : {
		width : 255,
		labelAlign : 'top'
	},
	items : [{
		xtype:'studenthealthinformationdocumentgrid',
		itemId:'studenthealthinformationdocumentgrid',
		hidden:true,
		style:{
			marginLeft:'0px',
		},
		flex:.1
	}]

},{
	xtype: 'fieldcontainer',    
	layout : {
		type : 'vbox'
	},
	cls:'horizontal-scrolling-fix',
	defaults : {
		width : 255,
		labelAlign : 'top'
	},
	items : [{
		xtype:'studenthealthinformationurlgrid',
		itemId:'studenthealthinformationurlgrid',
		hidden:true,
		style:{
			marginLeft:'0px',
		},
		flex:.1
	}]

},{
	xtype: 'fieldcontainer',    
	layout : {
		type : 'vbox'
	},
	cls:'horizontal-scrolling-fix',
	defaults : {
		width : 255,
		labelAlign : 'top'
	},
	items : [{
		xtype:'applicanthealthinformationdocumentgrid',
		itemId:'applicanthealthinformationdocumentgrid',
		hidden:true,
		style:{
			marginLeft:'0px',
		},
		flex:.1
	}]

},{
	xtype: 'fieldcontainer',    
	layout : {
		type : 'vbox'
	},
	cls:'horizontal-scrolling-fix',
	defaults : {
		width : 255,
		labelAlign : 'top'
	},
	items : [{
		xtype:'applicanthealthinformationurlgrid',
		itemId:'applicanthealthinformationurlgrid',
		hidden:true,
		style:{
			marginLeft:'0px',
		},
		flex:.1
	}]

},
{
    
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        },{
			 xtype: 'button',
			 name: 'healthDocument',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'healthDocument',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'healthDocumentUrl',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'healthDocumentUrl',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});