/**
 * This view is used for the student Head Wise Bills records.
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.HeadWiseBillsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.headwisebillsgrid',
	title: getPersonModuleTranslation('HEAD_WISE_BILLS'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.feeandpayment.adjustment.BillReceivableOnline');
	},
	columns: [{
		header : getCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billHeaderBillingDate',
		flex :1,
		renderer: function(date) {
			return dateRender(date);
		}
	},
	{
		header : getCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex : 1
	},
	{
		header : getCommonTranslation('FEE_HEAD_GROUP'),
		dataIndex : 'groupingFeeHeadName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getCommonTranslation('HEAD_WISE_AMOUNT'),
		dataIndex : 'totalAmount',
		flex : 1,
		summaryType: 'sum',
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			 if (store && store.data && store.data.items.length > 0) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                        
		}
	},
	{
		header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		dataIndex : 'totalAdjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		editing:true,
		summaryType: 'sum',
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			 if (store && store.data && store.data.items.length > 0) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},

		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                        
		}
	}]
});