/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerNextInstallmentSchedulesGrid', {
    //  extend: 'Ext.grid.Panel',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.feepayernextinstallmentschedulesgrid',
    title: getCommonTranslation('FEE_INSTALMENT_SCHEDULE'),
    border: true,
    // autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
		 xtype: 'rownumberer',
		 header: getPersonModuleTranslation('SCHEDULE_SEQUENCE'),
		 align :'center',
		 flex:.2
	 }, {
		header: getPersonModuleTranslation('SCHEDULE_INVOICE_DATE'),
		dataIndex: 'dueDate',
        sortable: true,
        flex: .2,
        renderer:function(val){		
			return dateRender(val);
		}
    }, {
        header: getFeeAndPaymentCommonTranslation('AMOUNT'),
        dataIndex: 'amount',
        sortable: true,
        flex: .2,
        renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.feeandpayment.PaymentScheduleForAdhoc');
    }
});