/**
 * @Author Vidhi Shah 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.PermitDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.permitgrid',
	title: getCommonTranslation('PERMIT_DETAILS'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	defaults:{
        width:'100%'
    },
    layout:'vbox',
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
	}],
	columns: [ {
		header: getCommonTranslation('PERMIT_TYPE'), 
		dataIndex: 'permitType.value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('PERMIT_NUMBER'), 
		dataIndex: 'permitNumber',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('COUNTRY_OF_ISSUE'), 
		dataIndex: 'countryOfIssue.value',
		sortable: true,
		flex: .2
	}, {
		header: getCommonTranslation('CANTON_OF_ISSUE'), 
		dataIndex: 'cantonOfIssue.value',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('IS_PERMIT_WITH_FAMILY'), 
		dataIndex: 'isPermitWithFamily',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.isPermitWithFamily==true?'True':'False';
			} else {
				return '';
			}                        
		}
	}, {
		header: getCommonTranslation('PERMIT_START_DATE'),
		dataIndex : 'studentPermitStartDate',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('PERMIT_EXPIRATION_DATE'),
		dataIndex : 'studentPermitExpirationDate',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('PERMIT_CANCELLATION_DATE'),
		dataIndex : 'studentPermitCancellationDate',
		sortable:true,
		flex: .2,
		hidden : true
	}, {
		header: getCommonTranslation('DATE_OF_DEPARTURE_ANNOUNCEMENT_TO_MIGRATION_OFFICE'),
		dataIndex : 'studentDateOfDepartureAnnouncement',
		sortable:true,
		flex: .2,
		hidden : true
	}, { 
		header: getCommonTranslation('REASON_FOR_PERMIT_CANCELLATION'),
		dataIndex : 'reasonForPermitCancellation',
		sortable:true,
		flex: .3,
		hidden : true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
    }, {
    	header: getCommonTranslation('DATE_SUBMITTED_TO_AUTHORITIES'),
    	dataIndex : 'studentDateSubmittedToAuthorities',
    	sortable:true,
		flex: .2,
		hidden : true
    }, {
    	header : getCommonTranslation('METHOD_OF_SUBMISSION'),
    	dataIndex : 'methodOfSubmission.value',
    	sortable:true,
		flex: .2,
		hidden : true,
	}, {
		header: getCommonTranslation('DATE_ISSUED'),
		dataIndex : 'studentDateIssued',
		sortable:true,
		flex: .2,
		hidden : true
	}, {
		header: getCommonTranslation('DATE_COLLECTED'),
		dataIndex : 'studentDateCollected',
		sortable:true,
		flex: .2,
		hidden : true
	}, {
		header: getCommonTranslation('IS_PRIMARY'), 
		dataIndex: 'isPrimary',
		sortable:true,
		flex: .2,
		hidden : true,
		 renderer:function(value, meta, record){
	            if(!isNullOrEmpty(value)) {
	                return record.data.isPrimary==false?'False':'True';
	            }                        
	        }
	}, {
		header: getCommonTranslation('UPLOADED_DOCUMENTS'), 
		dataIndex: 'permitDetailDocuments',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(record.data.permitDetailDocuments.length)) {
				if(record.data.permitDetailDocuments.length>1) {					
					return '<a href=#>'+record.data.permitDetailDocuments.length+'<a>';
				} else if(record.data.permitDetailDocuments.length==1) {
					var pathSplit=record.data.permitDetailDocuments[0].path.split('/');
                    var newPath=pathSplit[2];
					var newName=record.data.permitDetailDocuments[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('UPLOADED_URLS'),
		dataIndex: 'permitDetailUrlDocuments',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(record.data.permitDetailUrlDocuments.length)) {
				if(record.data.permitDetailUrlDocuments.length>1) {					
					return '<a href=#>'+record.data.permitDetailUrlDocuments.length+'<a>';
				} else if(record.data.permitDetailUrlDocuments.length==1) {
					var newPath=record.data.permitDetailUrlDocuments[0].path;
					var newName=record.data.permitDetailUrlDocuments[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return "<a href="+newPath+" target='_blank'>"+newValue;
				} 
			}                        
		}
	}],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.PermitDetailStore');
    }
});