Ext.define('Academia.view.personinfo.common.personalinfo.StudentPassportDocUrlListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentpassportdocurllistgrid',
	store :'personinfo.common.personalinfo.StudentPassportUrlGridStore',
	border: true,
	//autoScroll: true,
	height:'60%',
	maxWidth:850,
	//frame:false,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getPersonModuleTranslation('LIST_OF_URLS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.personalinfo.StudentPassportUrlGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	}/*,'->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}*/],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getPersonModuleTranslation('DOCUMENTS_URL'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				var newName=record.data.name;
                var newPath=record.data.path;    
                var val=!isNullOrEmpty(newName)?newName:newPath;
                return "<a href="+newPath+" target='_blank'>"+val;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});