/**
 * This view is used for the create faculty profile.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.faculty.CreateFacultyProfile', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.createfacultyprofile',
	cls: 'panelNoSpace',
	width: '100%',
	defaults: {
		autoScroll: true
	},
	layout: {
		type: 'border'
	},
	initComponent: function() {

		this.items = [{
			xtype: 'panel',
			region: 'center',
			cls: 'panelNoSpace',
			autoScroll: true,
			layout: {
				type: 'vbox'
			},
			items: [{
				/*xtype: 'panel',
			    layout: {
			        type: 'hbox'
			    },
			    width: '100%',
			    minWidth: 500,
			    height: 220,
                items: [ {
	                xtype: 'panel',
	                layout: {
				        type: 'vbox'
				    },
	                style: {
	                    marginTop: '0px !important'
	                },
	                height: 200,
	                width: '30%',
	                items: [{
		            	xtype:'image',
		                itemId: 'profile_image',
		                border: 1,
		                style: {
		                    borderColor: 'black',
		                    borderStyle: 'solid'
		                },
		                width: 130,
		                height: 150
		            }, {
		                xtype: 'button',
		                style: {
		                	marginLeft: '10px',
		                	marginTop: '10px'
		                },
		                text: getPersonModuleTranslation('FACULTY_ACTIVATE'),
		                itemId: 'facultyActivateButtonId',
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
	            },{
	                xtype: 'panel',
	                cls: 'panelNoSpace',
	                style: {
	                	marginLeft: '-10px !important',
	                    marginTop: '0px !important'
	                },
	                width: '60%',
	                items: [this.getCreateFacultyProfileView()]
	            }]
			}, {*/
				xtype: 'personinfopanel',
				minWidth: 800,
				/*style: {
                    marginTop: '-30px'
                },*/
				defaults: {
					border: false
				}
			}]
		},{
			xtype:'panel',
			width: '20%',
			region: 'east',
			layout:'vbox',
			cls: 'panelNoSpace',
			collapsible: true,
			border: true,
			defaults: {
				bodyStyle: 'padding:5px'
			},
			items:[{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items:[{
					xtype:'image',
					itemId: 'profile_image',
					border: 1,
					style: {
						borderColor: 'black',
						borderStyle: 'solid'
					},
					width: 130,
					height: 150
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items:[{
					xtype: 'button',
					text: getPersonModuleTranslation('FACULTY_ACTIVATE'),
					itemId: 'facultyActivateButtonId',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE	
				},this.getCreateFacultyProfileView()]
			},{
				xtype: 'persondetailslinkpanel',
				flex:1,
				collapsible: false,
				itemId : 'facultyPersonDetailsLinkPanel',
				width: '100%',
				personType : 'CREATE_FACULTY',
				border:false,
				cls: 'panelNoSpace'
			}]
		}];

		this.callParent(arguments);
	},
	getCreateFacultyProfileView: function() {

		var createFacultyProfile = new Ext.XTemplate('<tpl for="."><div class="thumb-wrap">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td style="width:50%;vertical-align:top;">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td align="center"><span>{firstName} {middleName} {lastName}</span></td>', 
				'</tr>', 
				'<tr>', 
				'<td align="center"><span>{phoneNo}</span></td>', '</tr>', 
				'<tr>', 
				'<td align="center"><span>{emailId}</span></td>', 
				'</tr>', 
				'</table>', 
				'</td>', 
				'</tr>', 
		'</table></div></tpl>');
		var createFacultyProfileView = {
				xtype: 'dataview',
				alias: 'widget.createfacultyprofileview',
				itemId: 'createFacultyProfileView',
				width: '100%',
				store: Ext.create('Academia.store.personinfo.faculty.FacultyProfileStore'),
				tpl: createFacultyProfile,
				itemSelector: 'div.thumb-wrap'
		};

		return createFacultyProfileView;
	}

});
