/**
 * This view is used for the faculty quick search form.
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.personinfo.faculty.FacultyQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyquicksearchform',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
    //layout: 'vbox',
    standardSubmit: false,
    items: [{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:240
		},
		items:[ {
			xtype:'panel',
			style:{
            marginLeft:'-9px !important'
        },
			width: 708,
			items:[ {
				xtype: 'multiselectcombofield',
            name: 'empMultiBrandCampusName',
            itemId: 'empMultiBrandCampusItemId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			width: 698,
	        labelAlign:'top',
  			cls:'multiBrandCampusCls',
  			typeAhead: true,
            allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
			}]
		}
            ]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        style:{
            marginTop:'-20px !important'
        },
        items: [{
        	 xtype: 'customcombobox',
             fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
             name: 'FACULTY_CODE',
             itemId:'facultyCodeItemId',
             store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo'),
             valueField: 'code',
 			 displayField: 'valueCode',
 			 queryParam:'nameOrCode',
 			 minChars:3,
 			 typeAhead:false,
 			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
 			 //hideTrigger:true,
			 forceSelection:true,
			 //allowBlank:false,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
				 listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('USER_GROUP_TYPE'),
			name:'USER_GROUP_TYPE',
			itemId : 'userGroupType',
			store: 'userGroup.UserGroupStore',
			valueField: 'id',
			displayField: 'userGroupName',
			//allowBlank: false,
			editable: false,
			queryMode : 'local'
		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('FACULTY_TYPE'),
			store : 'common.FacultyTypeCSMStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'FACULTY_TYPE',
			itemId:'facultyTypeId',
			editable: false,
			hidden:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getUserModuleTranslation('EMPLOYEE_TYPE'),
			store : 'user.EmployeeTypeStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'EMPLOYEE_TYPE',
			itemId:'employeeTypeId',
			editable: false,
			hidden:true
		}]
    },{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
          	 marginTop: '33px!important'
         },
		items:[{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
        items: [{
	    	xtype: 'customcombobox',
	    	name: 'COMMITTEE_ID',
	    	itemId:'committeeItemId',
	    	store:'committee.committee.CommitteeStore',
	    	displayField:'valueCode',
	    	valueField:'id',
	    	queryParam:'name',
	    	//typeAhead:false,
	    	//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    	//enableKeyEvents  : 'true',
	    	//hideTrigger:false,
	    	minChars:3,
	    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    //	triggerAcation: 'all',
			fourceSelection: true,
	    	listConfig: {
	    		listeners: {
	    			beforeshow: function(picker) {
	    				picker.minWidth = picker.up('combobox').getSize().width;
	    			}
	    		},
	    		loadingText: getCommonTranslation('SEARCHING'),
	    		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    		getInnerTpl: function() {
	    			return '<div class="search-item">' +
	    			'{value}' +
	    			'</div>';
	    		}
	    	},
	    	fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME")
	    },{
        xtype: 'customcombobox',
        itemId: 'cmbDepartment',
        fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
        valueField: 'id',
        displayField: 'value',        
        name: 'DEPARTMENT',
        editable: false,
        triggerAcation: 'all',
        fourceSelection: true,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.program.ProgramDepartmentStore');
                combo.bindStore(store);
            }
        }
    }, {
		xtype: 'customcombobox',
		itemId:'subDepartmentId',
		fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),
		//store: 'facilitiesresources.resourcebooking.subdepartmentFilterStore',
		valueField: 'id',
		displayField: 'name',        
		name : 'SUB_DEPARTMENT',
		editable: false,
		disabled:true,
		fourceSelection: true,	
		listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.subdepartmentFilterStore');
	                combo.bindStore(store);
	            }
	        }
	},{
        xtype: 'customcombobox',
        name: 'LEAVECATEGORY',
        itemId: 'leaveCategoryId',
        fieldLabel: getCommonTranslation('LEAVE_CATEGORY'),
        store: 'securitysetup.LeaveCategorTypeStore',
        valueField: 'id',
        displayField: 'value',
        forceSelection: true,
        editable: false,
    }, {
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('GENDER'), //Gender
        name: 'GENDER',
        itemId: 'gender',
        valueField: 'id',
        displayField: 'value',
        store: 'Academia.store.common.GenderTypeStore',
        editable: false,
    }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
    		xtype: 'customcombobox',
    		itemId:'designationCombo',
    		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
    		store: 'common.DesignationTypeStore',
    		valueField: 'id',
    		displayField: 'value',        
    		name : 'DESIGNATION_ID',
    		editable: false,
    		triggerAcation: 'all',
    		fourceSelection: true,
    	},{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_FROM'),
            itemId:'joiningDateFrom',
            name: 'JOINING_DATE_FROM',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            endDateField: 'joiningDateTo'
        },{
        	xtype: 'datefield',
        	fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_TO'),
        	itemId:'joiningDateTo',
        	name: 'JOINING_DATE_TO',
        	listeners: {
        		render: function(field) {
        			return dateFormatRender(field);
        		}
        	},
        	//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
        	vtype: 'daterange',
        	startDateField: 'joiningDateFrom'
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT_FROM'),
            itemId:'exitDateFrom',
            name: 'EXIT_DATE_FROM',
            listeners: {
                	  render: function(field) {
                		  return dateFormatRender(field);
                	  }
                  },
                //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            endDateField: 'exitDateTo'
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT_TO'),
            itemId:'exitDateTo',
            name: 'EXIT_DATE_TO',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            startDateField: 'exitDateFrom'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'statusCombo',
            name: 'STATUS',
            itemId:'statusComboItemId',
            value:true
        }]
        }]
         }, {
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items : [ {
		xtype : 'button',
		text : getCommonTranslation('SEARCH'),
		itemId : 'searchButtonId',
		formBind: true,
		buttonAlign : 'left',
		ui : 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE
	}, {
		xtype: 'button',
		text : getCommonTranslation('RESET'),
		itemId : 'resetButtonId',
		buttonAlign : 'left',
		ui : 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	} ]
	}]

});
