/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.faculty.uploaddownload.FacultyUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.facultyuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
			xtype:'uploadoptionradiogroup',
			width: 300,
	        //border: 0,
	        margin: 0,
			itemId:'employeeUpdateUploadOptionRadioGroupItemId'
			//hidden:true,
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{

				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('TEMPLATE_IMPORT_TYPE'),
				itemId: 'templateTypeFacultyUploadId',
				name: 'templateTypeFacultyUploadId', 
				width : 226,
				store:Ext.create('Ext.data.Store', {
					fields: ['id', 'value'],
					data : [
						{"id":"IMPORT_BULK_EMPLOYEESS_UPLOAD", "value":getCommonTranslation('IMPORT_EMPLOYEES')},
						{"id":"IMPORT_BULK_EMPLOYEE_OTHER_DETAILS", "value":getCommonTranslation('IMPORT_EMPLOYEE_OTHER_DETAILS')}
						]
				}),
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				allowBlank:false,
				labelAlign: 'top',
				value:'IMPORT_BULK_EMPLOYEESS_UPLOAD'
			
			},{
				xtype: 'customcombobox',
				name: 'importUtilityMasterId',
				itemId:'moduleName',
				store:'importutility.ModuleName',
				fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				width : 226,
				forceSelection:true,
				allowBlank:false
			}]
		},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 460,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
