/**
 * @author <a href="harshit.patidar@serosoft.in">Harshit patidar</a>
 *
 */
Ext.define('Academia.view.personinfo.student.AdditionalAdmissionApproverForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.additionaladmissionapproverform',
    items: [{
		xtype: 'container',
		layout: 'hbox',
		items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',                    
                },
                items: [{

    				xtype: 'customcombobox',
    				name:'secondApprover',
    				itemId:'secondApproverId',
    				store: 'common.AllActiveInactiveUser',
    				width:276,
    	    		fieldLabel: getCommonTranslation('ADDITIONAL_ADMISSION_APPROVER_TWO'),
    	    		readOnly:true,
    				valueField: 'id',
    				displayField: 'value',
    				queryParam:'codeOrName',
    					typeAhead:false,
    	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    	            enableKeyEvents  : 'true',
    	            hideTrigger:false,
    	            triggerAction: '',
    	            forceSelection:true,
    				  listConfig: {
    					  listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		                loadingText: getCommonTranslation('SEARCHING'),
    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                        '{value}' +
    		                    '</div>';
    		                }
    		            }
    			
    	    	}]
			},{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                    width:226
 
                },
                items: [{
    	        	xtype: 'customcombobox',
    				fieldLabel: getCommonTranslation('STATUS'),
    				store: Ext.create('Academia.store.personinfo.student.StudentApprovalStatusStore'),
    				itemId: 'statusId',
    				name: 'status',
    				valueField: 'value',
    				displayField: 'value',
    				forceSelection:true,
    				listConfig: {
    					loadingText: getCommonTranslation("SEARCHING"),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}' +
    						'</div>';
    					},
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    				}
    			},{
    	        	xtype: 'customcombobox',
    				fieldLabel: getCommonTranslation('REASON'),
    				store: Ext.create('Academia.store.personinfo.student.ReasonNonApprovedAdmissionStore'),
    				itemId: 'reasonId',
    				name: 'reason',
    				valueField: 'id',
    				displayField: 'value',
    				hidden:true,
    				forceSelection:true,
    				listConfig: {
    					loadingText: getCommonTranslation("SEARCHING"),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}' +
    						'</div>';
    					},
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    				}
    			}]
            
	    	},{

                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                    width:226

                },
			items: [{
	        	xtype: 'datefield',
	            fieldLabel: getCommonTranslation('INSPECTION_DATE'),
	            itemId: 'inspectionDate',
	            name: 'inspectionDate',
	            editable : false,
	            readOnly:true,
	            listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
	        },{
                xtype: 'textfield',
                name: 'comment',
                itemId: 'commentId',
				hidden:true,
                fieldLabel: getCommonTranslation('COMMENT'),
                maxLength: 255,
            }]
	    	}],
	},{
		xtype: 'container',
		layout: 'hbox',
		items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                    width:300
                    
                },
                items: [{
    				xtype: 'customcombobox',
    				name:'thirdApprover',
    				itemId:'thirdApproverId',
    				store: 'common.AllActiveInactiveUser',
    				width:276,
    	    		fieldLabel: getCommonTranslation('ADDITIONAL_ADMISSION_APPROVER_THREE'),
    	    		readOnly:true,
    				valueField: 'id',
    				displayField: 'value',
    				queryParam:'codeOrName',
    					typeAhead:false,
    	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    	            enableKeyEvents  : 'true',
    	            hideTrigger:false,
    	            triggerAction: '',
    	            forceSelection:true,
    				  listConfig: {
    					  listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		                loadingText: getCommonTranslation('SEARCHING'),
    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                        '{value}' +
    		                    '</div>';
    		                }
    		            }
    	    	
    	    	}]
			},{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                    width:226
                },
                items: [{
    	        	xtype: 'customcombobox',
    				fieldLabel: getCommonTranslation('STATUS'),
    				store: Ext.create('Academia.store.personinfo.student.StudentApprovalStatusStore'),
    				itemId: 'thirdStatusId',
    				name: 'thirdStatus',
    				valueField: 'value',
    				displayField: 'value',
    				forceSelection:true,
    				listConfig: {
    					loadingText: getCommonTranslation("SEARCHING"),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}' +
    						'</div>';
    					},
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    				}
    			},{
    	        	xtype: 'customcombobox',
    				fieldLabel: getCommonTranslation('REASON'),
    				store: Ext.create('Academia.store.personinfo.student.ReasonNonApprovedAdmissionStore'),
    				itemId: 'thirdReasonId',
    				name: 'thirdReason',
    				valueField: 'id',
    				displayField: 'value',
    				hidden:true,
    				forceSelection:true,
    				listConfig: {
    					loadingText: getCommonTranslation("SEARCHING"),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}' +
    						'</div>';
    					},
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    				}
    			}]
            
	    	},{

                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                    width:226
                },
			items: [{
	        	xtype: 'datefield',
	            fieldLabel: getCommonTranslation('INSPECTION_DATE'),
	            itemId: 'thirdInspectionDate',
	            name: 'thirdInspectionDate',
	            editable : false,
	            readOnly:true,
	            listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
	            vtype : 'daterange'
	        },{
                xtype: 'textfield',
                name: 'thirdComment',
                itemId: 'thirdCommentId',
				hidden:true,
                fieldLabel: getCommonTranslation('COMMENT'),
                maxLength: 255,
            }]
	    	}],
	},
	{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
    		labelAlign: 'top',
            width:226
    	},
                items: [{
    	        	xtype: 'customcombobox',
    				fieldLabel: getCommonTranslation('ACTIONED'),
    				store: Ext.create('Academia.store.personinfo.student.StudentApprovalActionedStore'),
    				itemId: 'actionedId',
    				name: 'actioned',
    				valueField: 'id',
    				displayField: 'value',
    				forceSelection:true,
    				listConfig: {
    					loadingText: getCommonTranslation("SEARCHING"),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code}' +
    						'</div>';
    					},
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    				}
    			}]
	}]
});
