/**
 * @author Ramkrishna yadav
 */
Ext.define('Academia.view.placement.createcompany.PersonCantactDetailGrid', {
	extend : 'Ext.grid.Panel',
    alias: 'widget.personcantactdetailgrid',
	store : 'placement.createcompany.PlacementPersonContactDetailsGridStore',
	title :getCommonTranslation('LIST_OF_CONTACT_PERSONS'),//List of Contact Persons
    border: true,
    autoScroll: true,
    margin:'25 0 0 0',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns :[{
		header:  getPlacementTranslation('COMPANY_CODE'),
		dataIndex: 'companyCode',
		flex:.2,
		sortable:true
	},{
		header : getCommonTranslation('NAME'),//Person Name
		dataIndex : 'contactName',		
		flex:.2
	},{
		header :getCommonTranslation('DESIGNATION'),//Designation
		dataIndex : 'designation',
		flex:.2
	},{
		header :getCommonTranslation('ADDRESS'),//Address
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "addressText");
		}
			
	},{
		header :getCommonTranslation('ADDRESS_PHONE_NUMBER'),//Phone No.1
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			var pno;
			if(!isEmpty(obj.phoneAreaCode))
       pno=obj.phoneCountryCode+"-"+obj.phoneAreaCode;
			
       if(!isEmpty(obj.phoneNo)){
       if(!isEmpty(pno)){
    	   return pno+"-"+obj.phoneNo;
       }else{
    	   return obj.phoneCountryCode+"-"+obj.phoneNo;
    	   }
       }else{
    	   return pno;
       }
			
		}
	},{
		header :getCommonTranslation('ADDRESS_MOBILE_NO'),//Phone No.2
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			if(obj.cellNo!=null){
				return	obj.cellCountryCode+"-"+obj.cellNo;
			}else{
				return columnObjRender(obj, "cellNo");
			}
			
		}
	},{
		header :getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),//Email Id 1
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "primaryeEmailId");
		}
	},{
		header :getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),//Email Id 2
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "alternateEmailId");
		}
	}],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
		//text : getCommonTranslation('ADD')
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
		//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],	
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [
        	{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
               store: 'placement.createcompany.PlacementPersonContactDetailsGridStore',
                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                displayInfo: true
            }
   ]
    }],
	showContactPersonDetailsForm: function() {				
			var winAddressDetailsForm=Ext.widget('placementcontactpersondetailswindow');
			winAddressDetailsForm.show();					
	}
});
