/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusApplyToProgramPeriodGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementcampusapplytoprogramperiodgrid',
	store: 'placement.placementcampus.PlacementCampusApplyToProgramPeriodGridStore',
	title: getCommonTranslation('PLACEMENT_PROGRAM_PERIOD'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementcampus.PlacementCampusApplyToProgramPeriodGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		
	},{
		header:  getPlacementTranslation('PLACEMENT_PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		/*renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}*/
	}]
});

