/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.placement.placementjob.ConfigureStageJobPostingWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.configurestagejobpostingwin',
	title:getPlacementTranslation('CONFIGURE_STAGE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'configurestagejobpostingfrmwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
				
		},{
			xtype:'fieldcontainer',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'nestedJsonCombo',
				name: 'slctnProcessStage',
				itemId:'selectionStage',
				fieldLabel: getPlacementTranslation('SELECTION_STAGE'),
				store: 'course.PlacementSelectionStageStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				itemId: 'minimumSeats',
				name: 'minSeat',
				fieldLabel: getPlacementTranslation('MINIMUM_SEATS'),
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				allowDecimals:false
			},{
				xtype: 'numberfield',
				itemId: 'maximumSeats',
				name: 'maxSeat',
				fieldLabel: getPlacementTranslation('MAXIMUM_SEATS'),
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				allowDecimals:false
		}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items:[{	
					xtype: 'nestedJsonCombo',
					name: 'entryCriteria',
					itemId:'entryCriteria',
					fieldLabel: getPlacementTranslation('ENTRY_CRITERIA'),
					//store: 'feeandpayment.FeeServiceStore',
					valueField: 'id',
					displayField: 'value',
					//allowBlank:false,
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'nestedJsonCombo',
					name: 'exitCriteria',
					itemId:'exitCriteria',
					//allowBlank:false,
					fieldLabel: getPlacementTranslation('EXIT_CRITERIA'),
					//store: 'coursetransaction.studymaterialdistribution.CoursesAllStore',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textarea',
				name: 'entryRuleDescription',
				itemId:'entryRuleDescription',
				fieldLabel: getPlacementTranslation('ENTRY_CRITERIA_DESCRIPTION')
			},{
				xtype: 'textarea',
				name: 'exitRuleDescription',
				itemId:'exitRuleDescription',
				fieldLabel: getPlacementTranslation('EXIT_CRITERIA_DESCRIPTION')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
//				width: 226,
				labelAlign: 'top'
			},
        	items : [{
        		xtype: 'datefield',
        		name: 'startDate',
        		itemId:'startDate',
        		width: 226,
        		allowBlank:true,
        		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
        		vtype: 'daterange',
    			endDateField: 'endDate',
    			editable:false,
        		fieldLabel:getPlacementTranslation('START_DATE')
        	},{
        		xtype: 'datefield',
        		name: 'endDate',
        		itemId:'endDate',
        		width: 226,
        		allowBlank:true,
        		vtype: 'daterange',
    			startDateField: 'startDate',
    			editable:false,
    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
        		fieldLabel:getPlacementTranslation('END_DATE')
        	}] 
			
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});