/**
 * @author Amit G
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationJoiningStatusWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.placementjobapplicationjoiningstatuswindow',
	title:getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'placementjobapplicationjoiningstatuswindow',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'placementCampus',
				itemId:'placementCampus',
				fieldLabel : getPlacementTranslation('PATH_PLACEMENT_CAMPUS')
				
			},{
				xtype:'displayfield',
				name:'recruitingOrganization',
				itemId:'recruitingOrganization',
				fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION')
			},{
				xtype:'displayfield',
				name:'jobtitle',
				itemId:'jobtitle',
				fieldLabel:getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE')
				
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'jobLocation',
				itemId:'jobLocation',
				fieldLabel:getPlacementTranslation('JOB_LOCATION')

			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
	            name: 'confirmedBy',
	            itemId:'confirmedBy',
	            store:'placement.placementcampus.placementCampusCoordinatorStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable:false,
	            typeAhead:true,
	            allowBlank:false,
	            fieldLabel:getCommonTranslation('CONFIRMED_BY'),

			},{	
				xtype: 'datefield',
        		name: 'dateOfJoining',
        		itemId:'dateOfJoining',
        		allowBlank:false,
        		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
				editable:false,
				//minValue: new Date(),
        		fieldLabel:getPlacementTranslation('DATE_OF_JOINING')
			}]
			
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});