/**
 * Raghavendra.Soni
 */
Ext.define('Academia.view.prereqnotmetreport.PreReqNotMetReportFilter' ,{   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.prereqnotmetreportfilter',  
	plugins : "formlabelrequired",
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'radiogroup',
			itemId : 'reportType',
			width: 500,
			column:2,
			layout: 'hbox',
			items : [{
				boxLabel : getCommonTranslation('PRE_REQ_NOT_MET_RECORDS'),
				name : 'reportType',
				itemId : 'allRecords',
				inputValue: true,
				checked : true	
					
			},{
				boxLabel : getCommonTranslation('INVALID_JSON_RECORDS'),
				name : 'reportType',
				itemId : 'invalidJsonRecords',
				inputValue: false
				
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
					xtype : 'customcombobox',
					width:226,
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseId',
					itemId : 'courseId',
					store:Ext.create('Academia.store.common.StudentAndCourseByPeriodIdStore'),
					displayField : 'courseCodeName',
					valueField : 'courseId',
					allowBlank : false,
					minChars:3,
					typeAhead : false,
					forceSelection:true,
					hideTrigger:false,
					triggerAction: 'all',
					queryParam:'courseName',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
						beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
								'{value}' +
								'</div>';
					}
					}
		}, {
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
				name: 'academicTerm',
				itemId: 'academicTerm',
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				hidden: false,
				width: 226,
				editable: false,
				allowBlank: false
			},{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.attendance.attendancereport.AcadmyByAdmission'),
			width:226,
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
		    		xtype : 'customcombobox',
		    		fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    		name : 'programId',
		    		itemId : 'programId',
		    		store: Ext.create('Academia.store.coursetransaction.studentenrollment.ProgramBatchPeriodByAcademicTermAndCourse'),
					displayField:'valueCode',
					valueField:'id',
					queryParam:'query',
					typeAhead : true,
					forceSelection:true,
					hideTrigger:false,
					triggerAction: 'all',
					disabled:true,
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
		     },{
			xtype:'customcombobox',
			name:'batch',
			fieldLabel: getCommonTranslation('SELECT_BATCH'),
			itemId:'batchId',
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.ProgramBatchPeriodByAcademicTermAndCourse'),
			displayField:'value',
			valueField:'id',
			forceSelection : true,
			allowBlank:true,
			editable : false,
			disabled:true,
			
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodId',
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.ProgramBatchPeriodByAcademicTermAndCourse'),
			fieldLabel: getExaminationTranslation('PERIOD'),
			editable: false,
			disabled:true,
			displayField: 'value',
			forceSelection:true,
			allowBlank:true,
			valueField: 'id'
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'multiselectcombofield',
			name : 'studentId',
			itemId : 'studentId',
			autoloadStore: false,
			width:226,
			store:Ext.create('Academia.store.common.StudentAndCourseByPeriodIdStore'),
			displayField : 'studentIdName',
			valueField : 'studentId',
			//queryParam:'courseName',
			//minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			cls:'resetPasswordMultiselect',
			//queryMode:'remote',
			//enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			maxLength:15000,
			fieldLabel : getCommonTranslation('STUDENT_ID_NAME'),
			typeAhead : true,
			disabled:true,
			editable:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype : 'multiselectcombofield',
			width:226,
			maxLength:15000,
			fieldLabel : getCommonTranslation('SU_NUMBER'),
			name : 'suNumber',
			itemId : 'suNumber',
			store: Ext.create('Ext.data.Store', {
				fields:['suNumber'],
			    data: []
			}),
			displayField : 'suNumber',
			valueField : 'suNumber',
			cls:'resetPasswordMultiselect',
			typeAhead : true,
			disabled:true,
			forceSelection : true,
			editable:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			queryMode: 'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{courseCodeName}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});	
