/**
 * @author Amit  G
 */
var gridStore = Ext.create('Academia.store.program.ManageProgramOutcomeStore');
Ext.define('Academia.view.program.OutcomeBasedEducationGrid.MapProgramOutComeGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mapprogramoutcomegrid',
    store: gridStore,
    title: getProgramandcourseTranslation('LIST_OF_PROGRAM_OUTCOMES'),
    border: true,
    autoScroll:false,
    frame: false,
    hidden:true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : gridStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		disabled:true
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			itemId: 'SaveBtn',
			ui: 'CustomBtnSubmit',
			text: getCommonTranslation('SAVE'),
			disabled:true
		 }]
		},
		{
			xtype: 'button',
			text: getExaminationTranslation('MANAGE_INDIRECT_ATTAINMENT'),
			itemId: 'manageIndirectbtnItemId',
			//ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			formBind :true,
			disabled:true
		}],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getProgramandcourseTranslation('PROGRAM_OUTCOME_CODE'),
        dataIndex: 'programOutComeCode',
        flex: 0.5,
        sortable: true,
        editor: {
        	xtype: 'textfield',
        	name: 'programOutComeCode',
        	width:50,
        	minValue:0,
        	maxLength: 15,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'programOutComeCode',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
        
    },{
        header: getAdmissionTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 0.5,
        sortable: true,
        editor: {
        	xtype: 'textfield',
        	name: 'description',
        	width:50,
        	minValue:0,
        	maxLength: 500,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'description',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
                    return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
                }	
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
    	beforeedit: function(editor, context) {
    		if(editor.context.field=='programOutComeCode'){
    				context.grid.columns[0].getEditor().setReadOnly(false);

    		}else if(editor.context.field=='description'){
    				context.grid.columns[1].getEditor().setReadOnly(false);

    		}
    	}
	},
	
	
    /*,
    getAllSelectedSalesStaffIdsSanctioning: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('staffId') && !isNullOrEmpty(rec.get('staffId'))){
    			ids.push(rec.get('staffId'));
    		}
    	});
    	return ids.join();
    }*/
});
