/**
 * @author Phool Singh Gour
 * 
 */
Ext.define('Academia.view.program.lessonplanning.LessonPlanDocumentGridDownload', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.lessonplandocumentgriddownload',
	store :'lessonplan.LessonPlanDocumentStore',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	title : getProgramandcourseTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'lessonplan.LessonPlanDocumentStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},
	tbar: ['->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}/*,{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	}*/],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		flex:.5,
		align :'left',
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value,rec){
			return value;
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});