/**
 * 
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.courseGroups.ProgramCourseGroupsForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.programcoursegroupsformwindow',
    modal: true,
    requires: ['Ext.ux.form.ItemSelector'],
    autoScroll:true,
    //resizable:true,
    title: getCommonTranslation('ASSIGN_COURSE_GROUP'),
//	translationKey: 'ASSIGN_COURSE_GROUP',
    maxHeight:600,
   // id: 'programCourseGroupsForm',
    //width: '70%',
    //margin:0,
    items: [{
        xtype: 'form',
        itemId: 'programCourseGroupsFormWindowItemId',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 226
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        items: [{
    xtype: 'itemselector',
    name: 'courseGroup',
    itemId: 'courseGroup_Id',
    width: 500,
    imagePath: '../ux/css/images/',
    store: 'program.programDetails.programBatches.courseGroup.ProgramCourseGroupAvialbleItemStore',
    displayField: 'valueCode',
    valueField: 'id',
    allowBlank: false,
    fromTitle: getCommonTranslation('AVAILABLE'),
    toTitle: getCommonTranslation('SELECTED'),
    delimiter: null,
    buttons: ['top','add','remove','bottom'],

    listeners: {
		afterrender: function(selector) {
            selector.isParentChildClient = selector.fromField.store.findBy(function(r) {
                return r.get("pbstId") != null && r.get("pbstId") !== 0;
            }) !== -1;
        },
       change: function(selector, newValue, oldValue) {
		  if (!selector.isParentChildClient) {
                return;
            }
        if (!Ext.isArray(oldValue)) {
            oldValue = [];
        }

        var added = Ext.Array.filter(newValue, function(id) {
            return !Ext.Array.contains(oldValue, id);
        });

        var removed = Ext.Array.filter(oldValue, function(id) {
            return !Ext.Array.contains(newValue, id);
        });

			Ext.each(added, function(id) {
				var rec = selector.toField.store.getById(id) || selector.fromField.store.getById(id);
				if (!rec) return;
				var pbstId = rec.get("pbstId");
				var children = [];
				selector.fromField.store.each(function(r) {
					if (r.get("pbstId") === rec.get("id")) children.push(r);
				});
				selector.toField.store.each(function(r) {
					if (r.get("pbstId") === rec.get("id")) children.push(r);
				});
				if (children.length === 0) {
					return;
				}
				moveChildren(rec, selector);
			});

        Ext.each(removed, function(id) {
            var rec = selector.fromField.store.getById(id);
            if (rec) {
                moveChildrenBack(rec, selector);
            }
        });
    }
    }
}
,{
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'button',
                //action : 'Submit',
                text: getCommonTranslation('SAVE'),
                itemId: 'programCourseGroupsFormSubmit',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'programCourseGroupsFormCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});