/**
 * 
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.courses.ProgramCoursesForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.programcoursesformwindow',
    modal: true,
    title: getCommonTranslation('COURSE'),
    autoScroll:true,
    resizable:true,
    frame:true,
    plugins:"formlabelrequired",
    items: [{
        xtype: 'dynamicfieldformwin',
        itemId: 'programCoursesFormItemId',
        method: 'POST',
        autoScroll:false,
        bodyPadding: '10 10 10 10',
        margin: 0,
        /*layout: {
            type: 'vbox'
        },*/
        /*defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 226
        },*/
        //plugins:"formlabelrequired",
        standardSubmit: false,
        items: [{
        	  xtype:'hidden',
        	  name:'id'
        },{
        	 xtype:'hidden',
        	 name:'version'
        },{
	       	 xtype:'hidden',
	    	 name:'assignSectionType'
	    },{
        	xtype : 'fieldcontainer',
        	width : '100%',
        	layout : {
//        		type : 'vbox'
        	},
        	defaults : {
        		width : 360,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype: 'radiogroup',
        		itemId:'whetherOptionalItemId',
        		name:'whetherOptionalItem',
        		defaults: {
           		 flex: 1
           	 	},
        		columns: 2,
//        		layout: 'hbox',
        		allowBlank: false,
        		fieldLabel: getCommonTranslation('COURSE_TYPE'),
        		items :[{ 
						boxLabel: getCommonTranslation('MANDATORY'),
						name:'whetherOptional', 
						inputValue: false,
						checked:true
				     },{ 
					    boxLabel: getCommonTranslation('OPTIONAL'),
	                    name:'whetherOptional', 
                        inputValue: true
                      }]
           	 },{
        		xtype:'multiselectcombofield',
        		name:'courseId',
        		fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
        		store:Ext.create('Academia.store.program.programDetails.programBatches.programCourse.ProgramCourseCodeStore'),
        		itemId:'courseItemId',
        		displayField:'valueCode',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
    			allowBlank: false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
        	},{
           		xtype : 'radiogroup',
                fieldLabel: getCommonTranslation('ENROLLMENT_CRITERIA'),
                name: 'enrollmentCriteriaId',
                hidden: true,
                layout: 'vbox',
                items : [{
                    boxLabel : 'First Come First Serve',
                    name : 'enrollmentCriteria',
                    inputValue : 'FIRST_COME',
                    checked:true
                },{
                    boxLabel : getCourseTxCommonTranslation('FACULTY_APPROVED'),
                    name : 'enrollmentCriteria',
                    inputValue : 'BY_FACULTY'
                }]
           	 },
        	]},
        	
        	{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width:'auto',
    			defaults: {
    				width: 200,
    				labelAlign: 'top',
    				cls:'checkBoxCourseCls'
    			},
    			items:[{
    				xtype:'checkbox',
        			itemId : 'isOfferedYearly',
        			name:'isOfferedYearly',
        			boxLabel:getCommonTranslation('IS_OFFERED_YEARLY'),
        			inputValue: true,
        			uncheckedValue: false
    			},{
    				xtype:'checkbox',
        			itemId : 'whetherMajor',
        			name:'whetherMajor',
        			boxLabel:getCommonTranslation('WHETHER_MAJOR'),
        			inputValue: true,
        			uncheckedValue: false
    			}
    			]},
        	
        	{
        		xtype:'fieldcontainer',
        		width:'100%',
        		cls:'windowBtnPos',
        		items: [{
        			xtype: 'button',
        			//action : 'Submit',
        			text: getCommonTranslation('SAVE'),
        			itemId: 'programCoursesFormSubmit',
        			ui: 'CustomBtnSubmit',
        			scale: CONSTANTS.BUTTONSIZE,
        			formBind: true
        		}, {
        			xtype: 'button',
        			text: getCommonTranslation('CANCEL'),
        			itemId: 'programCoursesFormCancel',
        			ui: 'CustomBtnCancel',
        			scale: CONSTANTS.BUTTONSIZE
        		}]
        	}]
    }]
});
