/**
 * @author seshagiri.k
 */
var store = Ext.create('Ext.data.JsonStore', {
    fields: ['name', 'data1'],
    data: [
        {'name':'SIBM', 'data1':435},
        {'name':'SLC', 'data1':180},
        {'name':'SCDL', 'data1':279},
        {'name':'SS', 'data1':85},
        {'name':'IIT', 'data1':200}                                                
    ]});

Ext.define('Academia.view.program.programDetails.viewHistory.admissionSummary.ProgramAdmissionSummaryStatisticsChart' ,{
	extend: 'Ext.chart.Chart',
	alias : 'widget.programAdmissionSummaryStatisticsChart',
	requires: ['Ext.chart.*', 'Ext.layout.container.Fit', 'Ext.window.MessageBox'],
	xtype: 'chart',
	animate: true,
	store: store,
	shadow: true,
	width: 450,
	height: 450,
	legend: {
	    position: 'left'
	},
	insetPadding: 60,
	theme: 'Base:gradients',
	series: [{
	    type: 'pie',
	    field: 'data1',
	    showInLegend: true,
	    tips: {
	      trackMouse: true,
	      width: 160,
	      height: 20,
	      renderer: function(storeItem, item) {
	        //calculate percentage.
	        var total = 0;
	        store.each(function(rec) {
	            total += rec.get('data1');
	        });
	        this.setTitle(storeItem.get('name') + ': ' + Math.round(storeItem.get('data1') / total * 100) + '%');
	      }
	    },
	    highlight: {
	      segment: {
	        margin: 20
	      }
	    },
	    label: {
	        field: 'name',
	        display: 'rotate',
	        contrast: true,
	        font: '18px Arial'
	    }
	}]
});
