/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.DailyLogOrSessionPBSReportFilter', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.dailylogorsessionpbsreportfilter',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey:'PROGRAM',
				name : 'programId',
				itemId : 'programId',
//				store:'common.ProgramsByAcademyLocationsIds',
				displayField:'valueCode',
				valueField:'id',
				width:226,
				typeAhead:true,
				forceSelection:true,
				allowBlank:false,
				queryParam:'programName',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
	            	render : function(combo){
	            		  var store=Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds');
	            		  combo.bindStore(store)
	            	}
	            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),		
				name : 'batchId',
				itemId : 'batchId',
//				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false,
				disabled:true,
				listeners  :{
	            	render : function(combo){
	            		  var store=Ext.create('Academia.store.enquiry.AcademicBatchStore');
	            		  combo.bindStore(store)
	            	}
	            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'periodId',
				itemId : 'periodId',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false,
				disabled:true,
				/*listeners  :{
	            	render : function(combo){
	            		  var store=Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	            		  combo.bindStore(store)
	            	}
	            }*/
			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults :{
					labelAlign:'top',
					width:226
				},
				items: [{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					name : 'programSectionId',
					itemId : 'programSectionId',
                	store : 'coursetransaction.sectionmanagement.SectionsStore',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false,
					hidden : false,
					disabled:true,
					/*listeners  :{
		            	render : function(combo){
		            		  var store=Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionsStore');
		            		  combo.bindStore(store)
		            	}
		            }*/
				},{
					xtype: 'datefield',
					name:'fromDate',
					itemId:'fromDate',
					fieldLabel:getProgramandcourseTranslation('DATE'),
					//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					endDateField: 'toDateId',
					editable:false,
					allowBlank : false
				}]
			},{
				xtype:'fieldset',
				title:getServiceRequestTranslation('MORE_FILTERS'),
				layout:'vbox',
				frame:true,	
				collapsible:true,
				collapsed:true,
				width:'100%',
				defaults: {
					labelAlign: 'top',
				},
				style: {
					marginTop: '40px!important',
				},
				items:[{
					xtype:'fieldcontainer',
					layout: 'hbox',
					defaults: {
						width: 226,
						labelAlign: 'top'
					},
					style:{
//						marginTop:'40px!important'
					},
					items:[{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
//						translationKey:'COURSE_VARIANT',
						name:'courseVariantPBSId',
						itemId: 'courseVariantPBSId',
						displayField: 'value',
						valueField: 'courseVariantId',
						typeAhead:true,
						forceSelection:true,
						allowBlank:true,
						disabled:false,
						queryParam:'name',
						minChars:3,
						width:226,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}'  +
								'</div>';
							}
						},
						listeners: {
							render: function(combo) {
								var store = Ext.create('Academia.store.examinationcenters.remark.CourseEvaluationRemark');
								combo.bindStore(store);
							}
						}
					},{
						xtype: 'customcombobox',
						fieldLabel: getCourseTxCommonTranslation('FACULTY'),
//						translationKey:'FACULTY',
						name: 'facultyPBSId',
						itemId:'facultyPBSId',
//						store:'common.ActiveUserStore',
						valueField: 'id',
						displayField: 'valueCode',
						queryParam:'name',
						minChars:3,
						typeAhead:false,
						hideTrigger:false,
						triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
						triggerAction: '',
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code} / {value}' +
								'</div>';
							}
						},
						listeners  :{
			            	render : function(combo){
			            		  var store=Ext.create('Academia.store.common.ActiveUserStore');
			            		  combo.bindStore(store)
			            	}
			            }
					},{
						xtype: 'datefield',
						name:'toDateId',
						itemId:'toDateId',
						fieldLabel:getServiceRequestTranslation('TO_DATE'),
						vtype: 'daterange',
						startDateField: 'fromDate',
						editable:false,
						//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
					}]	
				}]
			},{
				xtype: 'fieldcontainer',
				width: '100%',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					buttonAlign: 'left',
					formBind : true,
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE               
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
	}]

});