/**
 * @author Rajkumar.patidar
 */

/*var lineStore = Ext.create('Ext.data.JsonStore', {
	fields: ['SEAT_VACANT','SEAT_CAPACITY','SEAT_TYPE','BATCH_ID'],
	autoLoad:true,
	data: [
	       {
	    	   "ACADEMY_LOCATION": "Peoples College of Management - Bhopal",
	    	   "BATCH_NAME": "DEPT1/PRG1/1",
	    	   "ID": "1",
	    	   "PROGRAM_CODE": "PRG1",
	    	   "PROGRAM_NAME": "B Comm",
	    	   "SEAT_CAPACITY": "180",
	    	   "SEAT_VACANT": "10"
	       },{
	    	   "ACADEMY_LOCATION": "Peoples College of Management - Bhopal",
	    	   "BATCH_NAME": "DEPT1/PRG1/1",
	    	   "ID": "2",
	    	   "PROGRAM_CODE": "PRG1",
	    	   "PROGRAM_NAME": "B Comm",
	    	   "SEAT_CAPACITY": "200",
	    	   "SEAT_VACANT": "50"
	       } 
   
	]
});
*/
var gridStore = Ext.create('Ext.data.JsonStore', {
	fields: ['SEAT_VACANT','SEAT_CAPACITY','SEAT_TYPE','BATCH_ID'],
	data: []
});

var pieStore = Ext.create('Ext.data.JsonStore', {
	fields: ['SEAT_VACANT','SEAT_CAPACITY','SEAT_TYPE','BATCH_ID'],
	data: []
});

var grid = Ext.create('Ext.grid.Panel', {
	store: gridStore,
	 height: 130,
     width: 300,
	columns: [{
		header  : getCommonTranslation('TYPE'),
		dataIndex: 'SEAT_TYPE'
	},{
		header   : getCommonTranslation('CAPACITY'),
		dataIndex: 'SEAT_CAPACITY'
	},{
		header : getCommonTranslation('VACANT'),
		dataIndex: 'SEAT_VACANT'
	}]
});

var pieChart = Ext.create('Ext.chart.Chart', {
	width: 100,
	height: 100,
	animate: false,
	store: pieStore,
	shadow: false,
	insetPadding: 0,
	theme: 'Base:gradients',
	series: [{
		type: 'pie',
		field: 'SEAT_VACANT',
		showInLegend: false,
		label: {
			field: 'SEAT_TYPE',
			display: 'rotate',
			contrast: true,
			font: '9px Arial'
		}
	}]
});


Ext.define('Academia.view.programCourseDashboard.RichTipChartReport' ,{
	extend: 'Ext.chart.Chart',
	requires:['Ext.chart.*','Ext.layout.container.Fit','Ext.window.MessageBox','Ext.grid.Panel'],
	style: 'background:#fff',
	alias : 'widget.richtipchartreport',
	animate: true,
	shadow: false,
	autoSize:true,
	minWidth: window.innerWidth-150,
	minHeight:300,
	//width: 800,
	//height: 300,
//	insetPadding: 40,
	store:'programCourseDashboard.ProgramVacantSeatsChartStore',
	axes: [{
		type: 'Numeric',
		position: 'left',
		fields: ['SEAT_VACANT'],
		title: false,
		grid: true,
		label: {
			renderer: Ext.util.Format.numberRenderer('0,0')
		}
	}, {
		type: 'Category',
		position: 'bottom',
		fields: ['PROGRAM_CODE'],
		title: false
	}],
	series: [{
		type: 'line',
		axis: 'left',
		gutter: 80,
		xField: 'PROGRAM_NAME',
		yField: ['SEAT_VACANT'],
		tips: {
			trackMouse: true,
			 width: 400,
             height: 170,
			layout: 'fit',
			items: {
				xtype: 'container',
				layout: 'hbox',
				items: [pieChart, grid]
			},
			renderer: function(klass, item) {
				var store = Academia.store.programCourseDashboard.ProgramVacantSeatsBatchStore;
				var storeItem = item.storeItem;
				this.setTitle("Information for " + storeItem.get('BATCH_NAME'));
				pieStore.loadRawData(store.data);
				gridStore.loadData(store.data);
				pieStore.clearFilter(true);
				gridStore.clearFilter(true);
				pieStore.filter([{property: "BATCH_ID", value: storeItem.get('ID')}]);
				gridStore.filter([{property: "BATCH_ID", value: storeItem.get('ID')}]);
			}
		}
	}]
});
