/**
 * @author Ravi Choudhary


 */
var SectionRosterReportStore = Ext.create('Academia.store.programCourseDashboard.SectionRosterReportStore');
Ext.define('Academia.view.programCourseDashboard.SectionRosterReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sectionrosterreportgrid',
	store: SectionRosterReportStore,
	title: getExaminationTranslation('SECTION_ROSTER_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
	    items : [ {
	    	xtype : 'custompagingtoolbar',
	    	plugins:['pagesize'],
	    	store : SectionRosterReportStore,
	    	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	displayInfo : true
	    } ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [	{
		xtype : 'button',
		itemId:'sendMessageSectionRRBtn',
		text : getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	},'->',{
	    xtype : 'button',
	    itemId : 'exportSectionRosterReportsId',
	    tooltip : getExaminationTranslation('EXPORT_SECTION_ROSTER_REPORT'),
	    text : getExaminationTranslation('EXPORT_SECTION_ROSTER_REPORT')
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : .1,
		hidden :true
	},{
		header : getTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroup',
		flex : .1,
		hidden :true
	},{
		header:  getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	}
	,{
		header:  getCommonTranslation('ENROLLMENT_STATUS'),
		dataIndex: 'enrollmentStatus',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		}
	},{
		header:  getCommonTranslation('DATE_OF_ENROLLMENT'),
		dataIndex: 'enrollmentDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			 return dateRender(date);
		 }
	}
	,{
		header:  getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				 return '<a href=#>'+value+'</a>'
			}                        
		}
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1,
		hidden :true
	},{
		header:  getCommonTranslation('GENDER'),
		dataIndex: 'gender',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		}
	},{
		header:  getExaminationTranslation('FACULTY_NAME'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true
	}]
});
