/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.SectionRosterReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.sectionrosterreportsearchform',
	autoScroll:true,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.BatchIntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
            xtype: 'multiselectcombofield',
            name: 'PROGRAM_GROUP',
            itemId: 'programGroupId',
            store: 'common.AssignedProgramGroupStore',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            valueField: 'id',
            displayField: 'value',
            queryParam:'programgroupname',
            width: 460,
            typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
        }]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:460
		},
		items:[{
			xtype: 'multiselectcombofield',
			name:'programId',
			itemId:'programItemId',
			store:'common.AssignedProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			width:460,
			typeAhead:true,
			hideTrigger:false,
            minChars:3,
            forceSelection : true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'+
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'common.CurrentBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width:226,
			disabled:true,
			//allowBlank:false,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]	
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226,
		},
		items:[{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width:226,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionItemId',
			disabled:true,
			store:'attendance.SectionAndFacultyByPeriodID',
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'sectionId',
			displayField: 'sectionCode',
			width:226,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			store:'common.FacultyByProgramId',
			fieldLabel:getExaminationTranslation('FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			width:226,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226,
			},
				items: [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('ENROLLMENT_START_DATE'),
				name : 'enrollmentStartDate',
				itemId:'enrollmentStartDate',	
				endDateField : 'enrollmentEndDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('ENROLLMENT_END_DATE'),
				name : 'enrollmentEndDate',
				itemId:'enrollmentEndDate',
				startDateField : 'enrollmentStartDate',
				listeners: {
		            	  render: function(field) {
		            		  return dateFormatRender(field);
		            	  }
		              },
				vtype : 'daterange'
			}
			]},
		{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			//formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
