/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.view.programCourseDashboard.TopBottomCourseAbsenteeismSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.topbottomcourseabsenteeismsearch',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width: '100%',
			layout:'hbox',
			cls:'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'topOrBottomAttendanceId',				
				columns: 2,
				vertical: false,				
				items: [
				        { boxLabel: getProgramandcourseTranslation('TOP_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'TOP_ABSENTEEISM',checked:true},
				        { boxLabel: getProgramandcourseTranslation('BOTTOM_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'BOTTOM_ABSENTEEISM'}
				        ]
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout:'hbox',
			cls:'panelNoSpace',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				name : 'courseId',	
				itemId : 'courseId',
				//store : 'attendance.CoursesByAcademyLocationIds',
				store : 'attendance.CourseLevelAttendanceCourses',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				queryParam:'name',
				 minChars:3,
	  			typeAhead:true,
	  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width+50;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
	  			}
			},{
				xtype: 'textfield',	              
				name: 'attendancePercentage',
				itemId:'attendancePercentage',
				fieldLabel: getProgramandcourseTranslation('ATTENDANCE_IN_PERCENTAGE')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			}]

		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			width:'100%',

			items: [ {
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'btnSearch',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				// buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	},{
		xtype:'panel',
		items:[{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('TOP_AND_BOTTOM_COURSE_ABSENTEEISM'),
			width:'100%',
			itemId:'topBottomCourseAbsenteeismSearchGridId',
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]
});