/**
 * @author Amit G
 *
 */
Ext.define('Academia.view.receipt.receiptsettings.BankChargesSettingsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bankchargessettingsgrid',
    store: 'receipt.receiptsettings.BankChargesGridStore',
    title: getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'),
    border: true,
    sortable: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'receipt.receiptsettings.BankChargesGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), 
        iconCls: 'view-icon'
    }],
    columns: [{
        header: getFeeAndPaymentCommonTranslation('FEE_PAYMENT_MODES'),
        dataIndex: 'feePaymentMode',
        flex: 1,
        sortable: true,
        renderer:function(record, value, index){
        	if(!isNullOrEmpty(index.data.feePaymentMode.value)){
        		return index.data.feePaymentMode.value;
        	}
        }
    }, {
        header: getFeeAndPaymentCommonTranslation('BANK_DRAWN_ON_MASTER'),
        dataIndex: 'bankDrawnOnMaster',
        flex: 1,
        sortable: true,
        renderer:function(record, value, index){
        	if(!isNullOrEmpty(index.data.bankDrawnOnMaster.value)){
        		return index.data.bankDrawnOnMaster.value;
        	}
        }
    }, /*{
        header: getFeeAndPaymentCommonTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex: 1,
        sortable: true,
        renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
    }, {
        header: getFeeAndPaymentCommonTranslation('TO_DATE'),
        dataIndex: 'toDate',
        flex: 1,
        sortable: true,
        renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
    }*/{
        header: getFeeAndPaymentCommonTranslation('TODAY_BANK_CHARGES_APPLICABLE_PERCENTAGE'),
        dataIndex: 'todaysBankChargeApplicable',
        flex: 1,
        sortable: true
    },{
        header: getFeeAndPaymentCommonTranslation('DATE_WISE_BANKCHARGES'),
        dataIndex: 'fromDate',
        flex: 1,
        sortable: true,
        renderer : function(value){
			  return  '<a href="#">View</a>';
		}
    },{
        header: getCommonTranslation('THRESHOLD_LIMIT'),
        dataIndex: 'thresholdLimit',
        flex: 1,
        sortable: true,
        renderer : function(value){
			 if(!isNullOrEmpty(value)){
				 return value;
			 }else{
				 return '-';
			 }
		}
    }]
});