/**
 * @author Amit G
 *
 */
Ext.define('Academia.view.receipt.receiptsettings.DiscountDateSettingsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.discountdatesettingsgrid',
    store: 'receipt.receiptsettings.DiscountDateSettingsStore',
    title: getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'),
    border: true,
    autoScroll: false,
    sortable: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'receipt.receiptsettings.DiscountDateSettingsStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && !isNullOrEmpty(value.value)) {
                return value.value;
            }
            return '';
        }
    }, {
        header: getCommonTranslation('RS_BACK_DATE_DAYS'),
        dataIndex: 'backDateAllowInDays',
        flex: 1,
        sortable: true
    }]
});