/**
 * @author Amit G
 */
Ext.define('Academia.view.receipt.receiptsettings.EditBillSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.editbillsettingswin',
    title: getFeeAndPaymentCommonTranslation('BILL_SETTINGS'),
    width:550,
    height:300,
    modal: true,
    autoScroll: false,
    items: [{
        xtype: 'form',
        itemId: 'editBillSettingsFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id',
                itemId: 'idItemId'
            }, {
                xtype: 'customcombobox',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                autoloadStore: false,
                width: 460,
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                store: Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                readOnly: true
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'backDateAllowInDays',
                itemId: 'backDateAllowInDaysItemId',
                fieldLabel: getCommonTranslation('RS_BACK_DATE_DAYS'),
                allowBlank: false,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            },{
                xtype: 'numberfield',
                name: 'futureDateAllowInDays',
                itemId: 'futureDateAllowInDaysItemId',
                fieldLabel: getCommonTranslation('RS_FUTURE_DATE_DAYS'),
                allowBlank: true,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            }]
        },{/*
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			boxLabel: getFeeAndPaymentCommonTranslation('SHOW_ADDITIONAL_COLUMNS'),
			name: 'showAdditionalColumns',
			itemId: 'showAdditionalColumns',
			inputValue: true
		*/
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'right',
				width:230,
			},
			items:[{
				
				xtype: 'checkboxfield',
				boxLabel: getFeeAndPaymentCommonTranslation('SHOW_ADDITIONAL_COLUMNS'),
				name: 'showAdditionalColumns',
				itemId: 'showAdditionalColumns',
				inputValue: true
			   },{
				xtype: 'checkboxfield',
				boxLabel: getFeeAndPaymentCommonTranslation('DUE_DATE_EDITABLE'),
				name: 'dueDateEditable',
				itemId: 'dueDateEditable',
				inputValue: false
		     }]
			},{
				xtype:'fieldcontainer',
				width:400,
				layout : 'hbox',
				defaults: {
					labelAlign:'right',
					width:'100%',
				},
				items:[{
					xtype: 'checkboxfield',
					labelAlign: 'left',
					boxLabel: getCommonTranslation('BILL_GENERATION_ON_SUBMIT_APPLICATION'),
					name: 'billGenerationOnSubmitApplication',
					itemId: 'billGenerationOnSubmitApplication',
				}]
			},{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginLeft: '-3px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveEditBillSettingsWinItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelEditBillSettingsWinItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});