/**
 * Prashant choudhary
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupConfigureParentDetailsWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.registrationsetupconfigureparentdetailswindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('CONFIGURE_PARENT_DETAILS'),
	width:470,
	height: 360,
	resizable: false,
	items: [{
		xtype: 'grid',
		border: true,
		width: 400,
		itemId: 'configureAddressWinGrid',
		store:Ext.create('Ext.data.ArrayStore',{
			fields:['adrsId','addressType','whetherMandatory'],
			data:[
				['PG1', getPersonModuleTranslation('PARENT_GUARDIAN1'), false],
				['PG2', getPersonModuleTranslation('PARENT_GUARDIAN2'), false],
				['G', getPersonModuleTranslation('GUARDIAN'), false],
				['LG', getPersonModuleTranslation('LOCAL_GUARDIAN'), false],
				['V1', getPersonModuleTranslation('VISITOR 1'), false],
				['V2', getPersonModuleTranslation('VISITOR 2'), false]
			]
		}),
		columns:[
			{
				text: getCommonTranslation('CONFIGURE_PARENT_DETAILS'),
				dataIndex: 'addressType',
				flex: 1.5,
				sortable: false
			},
			{
				xtype : 'checkcolumn',
				text: getCommonTranslation('WHETHER_MANDATORY_ADRS'),
				dataIndex: 'whetherMandatory',
				flex: 1,
				sortable: false,
				listeners: {
					checkchange: function(checkColumn, rowIndex, checked) {
						if (checked) {
							var gridStore = checkColumn.up('grid').getStore(),
							record = gridStore.getAt(rowIndex);
							record.set('whetherVisible', true);
							record.commit();
						}
					}
				}
			},
			{
				xtype : 'checkcolumn',
				text: getCommonTranslation('WHETHER_VISIBLE'),
				dataIndex: 'whetherVisible',
				flex: 1,
				sortable: false,
				listeners: {
					beforecheckchange: function(checkColumn, rowIndex, checked) {
						var gridStore = checkColumn.up('grid').getStore(),
						record = gridStore.getAt(rowIndex);
						if (record.get('whetherMandatory') === true) {
							return false; // Cancels the toggle
						}
					}
				}
			}
		]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true,
			style:{
				marginLeft:'10px',
				marginBottom:'15px'
			}
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			style:{
				marginBottom:'15px'
			},
			handler: function(btn){
				btn.up('window').close();
			}
		}]	
	}]
});