/**
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.registrationsetupgrid',
	store: 'registrationsetup.RegistrationSetupGridStore',
	title: getCommonTranslation('REGISTRATION_SETUP_LIST'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sgappointmenttabstructure':1
		}
	},*/
	//isGridConfigurable: true,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'registrationsetup.RegistrationSetupGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		disabled:true,
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		disabled:true,
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnCopySetup',
		disabled:true,
		text:getCommonTranslation('COPY_SETUP'),
		tooltip :getCommonTranslation('COPY_SETUP')
		
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTermName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("REGISTRATION_SETUP_NAME"),
		dataIndex: 'registrationSetupName',
		flex:.1,
		sortable:true,
	},{
		header:  getCommonTranslation('SETUP_DETAIL'),
		dataIndex: 'setupDetails',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.registrationSetupId)){
				return '<a href=#>View</a>';
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation('REGISTRATION_MAPPING_DETAIL'),
		dataIndex: 'mappingDetails',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.registrationSetupId) && record.data.deleteStatus!="YES"){
				return '<a href=#>View</a>';
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation('Registration_Setup_Status'),
		dataIndex: 'status',
		flex:.1,
		sortable:true,
		renderer:function(val,meta,record) {
			var colorValue = '';
			if (val == 'Active') {
				colorValue = "<span style = 'color:#009e0f;'>" + val + "</span>";
			} else {
				colorValue = "<span style = 'color:#cc0000;'>" + val + "</span>";
			} 
			return colorValue;
		}
	}]
});

