/**
 * This is used for grouped bar chart report
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.common.GroupedBarChart', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.groupedbarchart',
    animate: true,
    legend : {
		position : 'right'
	},
    initComponent: function() {
        var this$ = this;
        var categoryField = !isNullOrEmpty(this.xAxesCategoryField)?this.xAxesCategoryField:'category';
        var groupField = !isEmpty(this.groupField)?this.groupField:'group';
        var count = !isNullOrEmpty(this.yAxesNumericField)?this.yAxesNumericField:'groupField';
        var numericTitle = !isNullOrEmpty(this.yAxesNumericTitle)?this.yAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.xAxesCategoryTitle)?this.xAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['category', 'group'],
        		data: [{
        			number :0,
        			category : 'Category',
        			group : 'Group'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
        	axes: [{
                type: 'Numeric',
                position: 'left',
                fields: groupField,
                minimum: 0,
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                },
                grid: true,
                title: numericTitle
            }, {
                type: 'Category',
                position: 'bottom',
                fields: categoryField,
                title: categoryTitle,
                label   : {
                    rotate:{degrees:270}

               }
            }],
            series: [{
                type: 'column',
                axis: 'left',
                xField: categoryField,
                yField: groupField,
                renderer: function(sprite, storeItem, barAttr, i, store) {
                	barAttr.width = 20;
              	  	return barAttr;
                },
                tips: {
                    trackMouse: true,
                    height: 28,
                    layout: 'fit',
                    renderer: function(storeItem, item) {
                  	  var tipTitle = storeItem.get(categoryField) + ': ' + item.value[1] ;
                  	  var length = (tipTitle.length)* 10;
                  	  this.setWidth(length);
                  	  this.setTitle(tipTitle);
                    }
                  }
            }],
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var chartWidth = (count * 40 * 4) + 120; 
                		chart.setWidth(chartWidth);
                		chart.doComponentLayout();
                	}
                }
            }
        });

        this$.callParent(arguments);
    }
});