/**
 * This view is used for completion dashboard search form
 * @author Prathamesh.Sheth
 * 
 */
Ext.define('Academia.view.reports.completion.CompletionSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.completionsearchform',
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        itemId: 'viewStatisticsForContainer',
        fieldLabel: getCompletionModuleTranslation('VIEW_STATISTICS_FOR'),
        labelAlign: 'top',
        layout: 'hbox',
        allowBlank: false,
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'entityName',
            itemId: 'statisticsForListCombo',                        
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            autoload: false,
            editable:false,            
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.completion.StatisticsForList');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'viewStatisticsByContainer',        
        labelAlign: 'top',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programComboField',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),            
            displayField: 'valueCode',
            valueField: 'id',
            //queryMode: 'local',
            autoload: false,
            typeAhead: true,
            forceSelection: true,
            triggerAction: 'all',
            minChars:3,
            queryParam:'qry',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            },
            listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchComboField',
            fieldLabel: getCommonTranslation('BATCH'),            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'sectionId',
            itemId: 'sectionComboField',
            fieldLabel: getCommonTranslation('SECTION'),            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 226,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        }/*{
            xtype: 'customcombobox',
            name: 'statisticsById',
            itemId: 'statisticsByListCombo',                        
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            autoload: false,
            editable:false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.completion.StatisticsByList');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'statisticsByDependentListId',
            itemId: 'statisticsByDependentListCombo',                        
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            editable:false,
            width: 226,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.completion.StatisticsByDependentList');
                    combo.bindStore(store);
                }
            }
        }*/]
    },{
        xtype: 'fieldcontainer',                
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            itemId: 'startDate',
            fieldLabel: getCommonTranslation('START_DATE'),
            name: 'startDate',
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId : 'endDate',
            fieldLabel: getCommonTranslation('END_DATE'),
            vtype: 'daterange',
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});