/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.reports.servicerequest.StudentMembershipRequestReportGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.studentMembershipRequestReportGrid',
	title: getServiceRequestTranslation('STUDENT_MEMBERSHIP_REQUEST_REPORT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getServiceRequestTranslation('REQUEST_ID'),
		dataIndex: 'requestId',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ value +'</a>';
		}
	},{
		header: getServiceRequestTranslation('STUDENT_ID'),
		dataIndex: 'studentName',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUESTER_NAME'),
		dataIndex: 'studentName',
		sortable: true,
		flex: .2
	}, {
		header: getCommonTranslation('GENDER'),
		dataIndex: 'gender',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value!=null){
				return	getCommonTranslation(value);
			}
			else
				return value;
		}
	}, {
		header: getServiceRequestTranslation('EMAIL_ID'),
		dataIndex: 'emailId',
		sortable: true,
		flex: .2
	},{
		header: getProgramandcourseTranslation('QUALIFICATION'),
		dataIndex: 'programeName',
		sortable: true,
		flex: .2
	},{
		header:getServiceRequestTranslation('SPORTS_TYPE'),
		dataIndex: 'sportsTypes',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value && value.length){
				return	result = Ext.Array.pluck(value, 'sportsTypeValue').join(', ');
			}
			else
				return '';
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_DATE'),
		dataIndex: 'requestDate',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		} 
	},{
		header: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex: 'assigneeName',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value){
				return	value;
			}
			else
				return 'Auto';
		}
	},{
		header: getServiceRequestTranslation('MEMBERSHIP_REQUEST_STATUS'),
		dataIndex: 'status',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('POSITION_PLAYED'),
		dataIndex: 'sportsTypes',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value && value.length){
				return	result = Ext.Array.pluck(value, 'positionPlayed').join(', ');
			}
			else
				return '';
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.reports.servicerequest.StudentMembershipRequestReportStore');
	}
});