/**
 * This view is used for student count of request
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.student.StudentServiceLevelView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.studentservicelevelview',
    title: getServiceRequestTranslation('SERVICE_LEVEL_GRAPH'),
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'servicelevelsearch',
        itemId: 'studentServiceLevelSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
    		xtype:'panel',
    		style:{margin:'0px'},
    		autoScroll: false,
    		width: '100%',
    		items:[{
    			xtype: 'groupedbarchart',
    			itemId: 'studentServiceLevelChart',
    			width: 700,
    			minHeight: 500,
    			maxHeight: 1000,
    			store: 'Academia.store.reports.servicerequest.ServiceLevelGraphStore',
    			xAxesCategoryField: 'MONTH',
    			xAxesCategoryTitle: getServiceRequestTranslation('MONTHS'),
    			yAxesNumericField: 'count',
    			yAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
    			groupField: ['Beyond Limit', 'Beyond', 'Before', 'OnDate']
    		}]
    	}]
    }]
});