/**
 * This view is used for the Inactive User Report List.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.systemutilization.inactiveusers.InactiveByTimeUserReport', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.inactivebytimeuserreport',
    cls: 'panelNoSpace',
    autoScroll: true,
 	layout:'vbox',
    defaults:{
    	width:'100%'
    },
    cls:'horizontalScrollingFixed' ,
    items: [{
        xtype: 'inactiveuserreportquicksearchform',
        itemId: 'inactiveUserByTimeSearch'
    }, {
        xtype: 'tabpanel',
        minWidth: 800,
        plain: true,
        activeTab: 0,
        items: [{
        	title: getCommonTranslation('INACTIVE_BY_TIME_USER_REPORT'),
            itemId: 'inactivebyusagetab',
        	items:[{
                xtype: 'inactivebyusagegrid',
                itemId: 'InactiveByUsageGrid',
                	style : {
                		marginTop : '25px',
                		marginLeft : '0px'
                	}
            }],
    		listeners: {
    			activate: function(me, eOpts){
    				var  contentPanelMain = me.up('inactivebytimeuserreport');
    				if(contentPanelMain){
    					setTimeout(function(){
    						contentPanelMain.scrollBy(0,1);
    						contentPanelMain.scrollBy(0,-1);
    					},30); 
    				}
    			}
    		}
        }, {
            xtype: 'groupedbarchart',
            style :{
            	marginTop : '10px'
            },
            title: getCommonTranslation('GROUP_AND_MONTH_WISE_SUMMARY'),
            itemId: 'inactiveusergroupwiseandmonthwisesummary',
            minHeight: 400,
            store: 'Academia.store.reports.systemutilization.inactiveusers.InactiveUserByUsageMonthwiseSummaryStore',
            xAxesCategoryField: 'MONTH',
            xAxesCategoryTitle: getServiceRequestTranslation('MONTHS'),
            yAxesNumericField: 'count',
            yAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            groupField: ['Admin','Faculty' ,'Student']
        }, {
           xtype: 'panel',
            title: getCommonTranslation('GROUP_WISE_SUMMARY'),
            itemId: 'inactiveusergroupwisesummary',
            width: '70%',
            items: [{
            	xtype: 'columnchartreport',
                itemId: 'groupwisesummaryChart',
                width: 700,
                minHeight: 400,
                columnWidth: 50,
                columnColor: 'orange',
                store: 'Academia.store.reports.systemutilization.inactiveusers.InactiveUserGroupwiseandMonthwiseSummaryStore',
                xAxesNumericField: 'count',
                xAxesNumericTitle: getCommonTranslation('NO_OF_USERS'),
                yAxesCategoryField: 'property',
                yAxesCategoryTitle: getServiceRequestTranslation('USER_GROUP_NAME') 
            }]
        }]
    }]
});
