Ext.define('Academia.view.reports.systemutilization.inactiveusers.InactiveByUsageGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.inactivebyusagegrid',
	store:'reports.systemutilization.inactiveusers.InactiveUserByUsageGridStore',
	title : getCommonTranslation('INACTIVE_BY_TIME_USER_REPORT'),
	border : true,
	frame:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.systemutilization.inactiveusers.InactiveUserByUsageGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns : [{
		text : getAdmissionTranslation('USER_CODE'),
		dataIndex: 'userCode',
		flex: 1
	}, {
		text : getAdmissionTranslation('IP_ADDRESS'),
		dataIndex : 'ipAddress',
		flex: 1
	}, {
		text : getAdmissionTranslation('USERNAME'),
		dataIndex : 'userName',
		flex: 1
	}, {
		text : getAdmissionTranslation('USERS_WHETHERINTERNAL'),
		dataIndex : 'whetherInternal',
		flex: 1,
		renderer : function(value){
			if (value === true){
				return getAdmissionTranslation('INTERNAL');
			}else{
				return getAdmissionTranslation('EXTERNAL');
			}
		}
	}, {
		text : getAdmissionTranslation('TOTAL_TIME_SPEND'),
		dataIndex : 'userTotalTimeSpent',
		flex: 1,
		renderer: function(obj) {
			var v1 = parseFloat(obj);
			var hr=v1/60,min=v1%60;
			hr=parseInt(hr);
			var sec = min - Math.floor(min);
			sec=parseInt(sec*100);
			min=parseInt(min);
			if(sec>60)
				min=min+1;
//			min=min.toFixed(2);
			return hr+" : "+min; 
		}
	}]/*,
	 initComponent: function() {
	        var this$ = this;
	        this$.addExportToolBarItems(this$);

	        this$.callParent(arguments); 
	        var store = this$.buildStore();
	        Ext.apply(this$, {
	            store: store,
	            dockedItems: [{
	                xtype: 'toolbar',
	                dock: 'bottom',
	                items: [{
	                    xtype: 'custompagingtoolbar',
	                    plugins: ['pagesize'],
	                    store: store,
	                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	                    displayInfo: true
	                }]
	            }]
	        });

	        this$.callParent(arguments);
	    },
	    buildStore: function() {
	        return Ext.create('Academia.store.reports.systemutilization.inactiveusers.InactiveUserByUsageGridStore');
	    }*/
});