/**
 * This view is used for the inactive user report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.systemutilization.inactiveusers.InactiveUserReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.inactiveuserreportquicksearchform',
    method: 'POST',
    defaults: {
        labelAlign: 'top'
    },
    
    frame: false,
    cls:'customSearchPanel',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        style : {
        	marginLeft : '10px',
        	marginTop : '10px'
        },
        items: [{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			maxValue : new Date(),
            fieldLabel: getCommonTranslation('FROM_DATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            endDateField : 'toDate',
	        vtype : 'daterange'
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			maxValue : new Date(),
            fieldLabel: getCommonTranslation('TO_DATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        startDateField : 'fromDate',
	        vtype : 'daterange'
		},{
        	xtype:'customcombobox',
            fieldLabel: getCommonTranslation('ACADLOCTT'),
            name: 'ACADEMY_LOCATION_ID',
			store : 'common.AllActiveAcademyLocationStore',
			valueField : 'id',
			displayField : 'academyLocationName',
			editable:false,
			forceSelection :true
		}]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        style : {
        	marginLeft : '10px',
        	marginTop : '15px'
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('NOT_LOGGED_IN_SINCE_DAYS'),
            allowBlank: false,
            itemId: 'notLogedInSince',
            name: 'NOT_LOGGED_IN_SINCE_DAYS',
            minValue : 0
        },{
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('TOTAL_USAGE_LIMIT'),
            allowBlank: false,
            itemId: 'totalUsageLimit',
            name: 'totalUsageLimit',
            allowDecimals:false,
            minValue : 0
    	},{
        	xtype:'customcombobox',
            fieldLabel: getCommonTranslation('SELECT_USER_GROUP'),
            name: 'USER_GROUP_NAME',
			store : 'common.UserGroupTypeStore',
			value:'ALL',
			valueField : 'code',
			displayField : 'value',
			editable:false,
			forceSelection :true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        style : {
        	marginLeft : '9px',
        	marginTop : '7px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'inactiveUserReportListSearchButtonId',
            formBind: true,
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]

    }]

});