/**
 * @author Rajkumar.Patidar


 */

var applicableFor =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"STUDENT", "name":"Student"},
        {"value":"APPLICANT", "name":"Applicant"}]
});

var ManageScholarshipStatusDetails =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"NOMINATED", "name":getCommonTranslation('NOMINATE')},
        {"value":"ACCEPTANCE_PENDING", "name":getCommonTranslation('AWARD')}]
});

Ext.define('Academia.view.scholarship.managescholarship.ScholarshipApplicationForm',{
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.scholarshipapplicationform',
	autoScroll: false,
	frame: true,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		itemId:'recordId'
	},{
		xtype: 'displayfield',
        fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_NUMBER'),
     //   cls:'ScholarshipNumber'
	},{
		xtype : 'fieldcontainer',
		itemId : 'dd',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'applicableFor',
			store:applicableFor,
			itemId:'applicableFor',
			fieldLabel: getCommonTranslation('APPLICABLE_FOR'),
			valueField: 'value',
			displayField: 'name',
			typeAhead:false,
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		
        },{
        	xtype: 'customcombobox',
        	fieldLabel: getCommonTranslation('STUDENT_STATUS'),
        	name: 'stStatus',
        	itemId: 'stdStatus',
        	editable: false,
        	allowBlank:false,
        	store: Ext.create('Ext.data.Store', {
        		fields: ['name', 'value'],
        		data : [{
        			name:getCommonTranslation('SCHL_ACTIVE'), value:"ACTIVE"
        		},{
        			name:getCommonTranslation('SCHL_INACTIVE'), value:"INACTIVE"
        		},{
        			name:getCommonTranslation('SCHL_ALL'),value:'ALL'
        		}]
        	}),
        	valueField: 'value',
        	displayField: 'name',
        	queryMode: 'local',
        	value: 'ACTIVE',
        	forceSelection: false
        },{
			xtype: 'customcombobox',
			name: 'applicantIdOrName',
			itemId:'applicantIdOrName',
			hidden:true,
			width : 460,
			//allowBlank:false,
			fieldLabel: getCommonTranslation('APPLICANT_ID_NAME'),
			store: 'scholarships.ScholarshipApplicantStore',
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{

			xtype: 'customcombobox',
			name: 'studentIdOrName',
			itemId:'studentIdOrName',
			hidden:false,
			width : 460,
			fieldLabel: getCommonTranslation('STUDENT_ID_NAME'),
			store: Ext.create('Academia.store.scholarships.ScholarshipStudentStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			queryCaching: false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		
		}]
	
	},{

		xtype : 'fieldcontainer',
		itemId : 'inherit_pro_Id',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            name: 'fnpBrandCampusName',
            itemId: 'fnpBrandCampusItemId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: 'scholarships.ScholarshipsFacultyCampusStore',
			readOnly:false,
			 queryMode: "local",
			editable:false,
			allowBlank:false,
			typeAhead:true,
			hidden:false,
			disabled:true,
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'programBatchCode',
			itemId:'programBatchCode',
			fieldLabel: getCommonTranslation('PROGRAM_ID_NAME'),
			store: 'scholarships.ScholarshipsProgramStore',
			valueField: 'programId',
			displayField: 'valueCode',
			queryMode: "local",
			readOnly:false,
			editable:false,
			allowBlank:false,
			typeAhead:true,
			hidden:false,
			disabled:true,
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'departmentalId',
			itemId:'departmentalId',
			fieldLabel: getFeeAndPaymentCommonTranslation('DEPARTMENT_ID_NAME'),
			store: Ext.create('Ext.data.Store', {
				fields: [{
		            name: 'departmentShortCode',
		            type: 'string'
		        }, {
		            name: 'departmenetName',
		            type: 'string'
		        }, {
		            name: 'departmentId',
		            type: 'string'
		        }]
			    
			}),
			valueField: 'departmentId',
			displayField: 'departmenetName',
			readOnly:true,
			editable:false,
			typeAhead:true,
			hidden:false,
			disabled:true,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype:'hidden',
			name: 'stdBatchId',
			itemId:'stdBatchId',
		},{

			xtype: 'textfield',
			name: 'Batch',
			itemId:'BatchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store: 'feeandpayment.managebill.FindBatchByProgram',
			valueField: 'id',
			displayField: 'value',
			readOnly:false,
			editable:false,
			typeAhead:true,
			disabled:true,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			}
		}]
	},
	{


		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			minHeight:55,
			labelAlign : 'top',
			//cls:'boldClsDisplayLabel'
		},
		items : [
			{
		        xtype: 'displayfield',
		        fieldLabel:getAdmissionTranslation('ADMISSION_STATUS'),
		        name: 'admissionStatus',
		        itemId: 'admissionStatus',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getAdmissionTranslation('COUNTRY'),
		        name: 'country',
		        itemId: 'country',
		        value:'NA'
		    },{
		        xtype: 'displayfield',
		        fieldLabel: getAdmissionTranslation('ID_TYPE'),
		        name: 'idType',
		        itemId: 'idType',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('ID_TYPE_NUMBER'),
		        name: 'idTypeNumber',
		        itemId: 'idTypeNumber',
		        value:'NA'
		    }]
	
	},
	{


		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			minHeight:55,
			labelAlign : 'top',
			//cls:'boldClsDisplayLabel'
		},
		items : [
			{
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('INCOMING_STUDENT_STATUS'),
		        name: 'studentStaus',
		        itemId: 'studentStaus',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getCommonTranslation('EXTERNAL_REFERENCE_NUMBER'),
		        name: 'externalNumber',
		        itemId: 'externalNumber',
		        value:'NA'
		    },{
		        xtype: 'displayfield',
		        fieldLabel: getCommonTranslation('GENDER'),
		        name: 'gender',
		        itemId: 'gender',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getCommonTranslation('AGE'),
		        name: 'age',
		        itemId: 'age',
		        value:'NA'
		    }]
	
	},
	{


		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			minHeight:55,
			labelAlign : 'top',
			//cls:'boldClsDisplayLabel'
		},
		items : [
			{
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('RACE'),
		        name: 'race',
		        itemId: 'race',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getCommonTranslation('HOSTEL_CODE_NAME'),
		        name: 'hostelCodeName',
		        itemId: 'hostelCodeName',
		        value:'NA'
		    },{
		        xtype: 'displayfield',
		        fieldLabel: getCommonTranslation('LIVING_ARRANGEMENT'),
		        name: 'livingArrangement',
		        itemId: 'livingArrangement',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('ACCREDITATION_STATUS'),
		        name: 'accreditaionStatus',
		        itemId: 'accreditaionStatus',
		        value:'NA'
		    }]
	
	},
	{


		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			minHeight:55,
			labelAlign : 'top',
			//cls:'boldClsDisplayLabel'
		},
		items : [
			{
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('ACCOMMODATION_PROVIDER_NAME'),
		        name: 'accommodationProvidder',
		        itemId: 'accommodationProvidder',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('FEE_BALANCE'),
		        name: 'feeBalance',
		        itemId: 'feeBalance',
		        value:'NA'
		    },{
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('GRADE_12_RESULT'),
		        name: 'gradeResult',
		        itemId: 'gradeResult',
		        value:'NA'
		    }, {
		        xtype: 'displayfield',
		        fieldLabel: getFeeAndPaymentCommonTranslation('PREVIOUS_YEAR_AVERAGE'),
		        name: 'previousYearAverage',
		        itemId: 'previousYearAverage',
		        value:'NA'
		    }]
	
	},
	{


		xtype : 'fieldcontainer',
		itemId : 'ssf',
		width : '100%',
		hidden:true,
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [
		    {
    		xtype: 'textfield',
    		name: 'externalRefNum',
    		itemId:'externalRefNum',
    		fieldLabel: getCommonTranslation('EXTERNAL_REFERENCE_NUMBER'),
    		editable: false,
    		valueField: 'id',
    		hidden:true,
    		  disabled:true,
    		readOnly:true,
    		displayField: 'value',
    		forceSelection:true,
    		typeAhead:false,
    		hidden:false,
 		//	minChars:3,
			queryMode:'local',
			anyMatch:true
    	}]
	
	},

{
	xtype : 'fieldcontainer',
	itemId : 'ssl',
	width : '100%',
	layout : {
		type : 'hbox'
	},
	defaults : {
		width : 226,
		labelAlign : 'top'
	},
},
{
	xtype : 'fieldcontainer',
	itemId : 'ss',
	width : '100%',
	layout : {
		type : 'hbox'
	},
	defaults : {
		width : 226,
		labelAlign : 'top'
	},
	items : [{
    	xtype: 'textfield',
    	fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_NUMBER'),
    	itemId: 'scholarshipAppNumber',
    	name: 'scholarshipAppNumber',
    	emptyText: getCommonTranslation('ID_AUTOGENERATE'),
    	readOnly:true
    },{
		xtype: 'customcombobox',
		name: 'accountingYear',
		itemId: 'accountingYearId',
		fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
		store:'scholarships.ScholarshipAcountingYearStore',
		valueField: 'id',
		displayField: 'currentAccountingYear',
		allowBlank:false,
		typeAhead:true,
		forceSelection:true
	},{
		xtype: 'customcombobox',
        itemId:'scholarshipCategoryId',
         editable: false,
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        fieldLabel: getCommonTranslation('SCHOLARSHIP_CATEGORY'),
        name: 'scholarshipCategory',
        store:Ext.create('Academia.store.scholarships.ManageScholarshipCategoryStore'),
        forceSelection:true,
        allowBlank: false,
        width:226,
	},{
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
        itemId: 'scholarshipId',
        name: 'scholarshipId',
        enableKeyEvents: true,
        allowBlank:false,
        disabled:true,
        vtype: 'NospaceAsInput',
        store:'feeandpayment.managebill.ScholarshipIdOrNameStore',
		width:226,
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'qry',
		minChars:3,
		typeAhead:false,
		triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		forceSelection:true,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code} / {value}' +
				'</div>';
			}
		}
	}]

},{
	xtype : 'fieldcontainer',
	itemId : 'ssj',
	width : '100%',
	layout : {
		type : 'hbox'
	},
	defaults : {
		width : 226,
		labelAlign : 'top'
	},
	items : [{
		xtype: 'customcombobox',
		name:'status',
		itemId:'statusId',
		store:ManageScholarshipStatusDetails,
		allowBlank:false,
		fieldLabel: getFeeAndPaymentCommonTranslation('ACTIVITY'),
		valueField: 'value',
		displayField: 'name',
		value:'NOMINATED',
		typeAhead:false,
		forceSelection:true,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code} / {value}'+ 
				'</div>';
			}
		}

	},{
		xtype: 'numberfield',
		itemId: 'amountId',
		fieldLabel: getCommonTranslation('AMOUNT'),
		labelAlign: 'top',
		width: 130,
		name: 'amount',
		minValue: 1,
		maxLength:13,
        //allowBlank: false,
    	hideTrigger:true,
    	hidden:true,
    	mouseWheelEnabled:false,
	},{
		xtype: 'customcombobox',
		name: 'Transcation',
		itemId: 'TranscationId',
		fieldLabel: getCommonTranslation('TRANSACTIONID'),
		store:'scholarships.ScholarshipTranscationStore',
		valueField: 'id',
		displayField: 'code',
		hidden:true,
		disabled:false,
		typeAhead:true,
		forceSelection:true
	}]
},{
	xtype:'scholarshipHistoryGrid',
	width:'100%'
},
	{
	xtype:'fieldcontainer',
	width:'100%',
	layout : 'hbox',
	items: [{
		xtype: 'button',
		text: getCommonTranslation('SAVE'),
		formBind: true,
		itemId: 'SubmitBtn',
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		ui: 'CustomBtnCancel',
		itemId: 'CancelBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('CANCEL'),
		ui: 'CustomBtnCancel',
		hidden:true,
		itemId: 'closeBtn',
		scale: CONSTANTS.BUTTONSIZE
	}]
}]
});