/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of awardees in grid  
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.ViewAwardeesGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.viewawardeesgrid',
	store : 'scholarships.ViewAwardeesGridStore',
	title :getCommonTranslation('LIST_OF_AWARDEES'),//List Of Awardees
    border: true,
    autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns :[{
		header : getCommonTranslation('STUDENT_ID'),//Student Id
		dataIndex : 'studentCode',
		flex:.2
	},{
		header : getCommonTranslation('STUDENT_NAME'),//Student Name
		dataIndex : 'studentName',		
		flex:.2
	},{
		header :getCommonTranslation('APPLIED_ON'),//Applied On
		dataIndex : 'appliedOn',
		flex:.2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header :getCommonTranslation('APPROVED_DATE'),//Approved Date
		dataIndex : 'awardedOn',
		flex:.2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header :getCommonTranslation('AWARDS_DATE'),//Awards Date
		dataIndex : 'validFrom',
		flex:.2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header :getCommonTranslation('VALID_TILL'),//Valid Till
		dataIndex : 'validUpto',
		flex:.2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header :getCommonTranslation('AMOUNT_RECIEVED'),//AMOUNT
		dataIndex : 'scholarshipAmount',
		flex:.2
	},{
		header :getCommonTranslation('DISBURSEMENT_DETAILS'),//Disbursement Details
		dataIndex : 'disbursementId',
		flex:.2,
		renderer:function(){
			return '<a href="#" >'+getCommonTranslation('VIEW')+'</a>';
		}
	}],
	tbar:[{
		xtype:'hidden',		
		itemId:'scholarship_Id'
	},{
	    xtype: 'customcombobox',        
	    itemId: 'cmbStatus',
	    fieldLabel: getCommonTranslation('STATUS'), //Status
	    store: 'scholarships.ViewAwardeeStatusComboStore',	    
	    valueField: 'id',
	    displayField: 'value',
	    emptyText:getCommonTranslation('SELECT_STATUS'), //Select Status
	    editable: false,	    
	    queryMode: 'local',	    
	    triggerAction: 'all',
	    forceSelection: true,
	    allowBlank: false
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'scholarships.ViewAwardeesGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }]
});