/**
 * @author Rohit Sharma
 * 
 * This component is used for to show associate academy locations,programs,courses.     
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.DocsAndRefStructure', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.docsAndRefStructure',
    plain: true,
    autoScroll: true,
    reserveScrollbar: true,
    layout: 'vbox',
    defaults: {
    	width: '100%'
    },
    items: [{
    	xtype: 'grid',
    	store: 'scholarships.DocsAndRefGridStore',
    	border: true,
    	viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        headerFix: {
    		headerFix: true,
    		portalIdsWithStructure: {
    			'scholarshipApplyToSearchTab': 1
    		}
        },
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            itemId: 'dockedItemsItemId',
            items: [{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
                store: 'scholarships.DocsAndRefGridStore',
                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                displayInfo: true
            }]
        }],
        tbar: [{
        	xtype: 'button',
        	itemId: 'btnAdd',
        	glyph: ICONGLYPH.ADDGLYPH,
        	tooltip :getCommonTranslation('ADD')
        }, {
    		xtype: 'button',
    		itemId: 'btnEdit',
    		tooltip: getCommonTranslation('EDIT'),
    		glyph: ICONGLYPH.EDITGLYPH
    	}, {
        	xtype: 'button',
        	itemId: 'btnDelete',
        	glyph: ICONGLYPH.DELETEGLYPH,
        	cls: 'CustomToolbarBtnReject',
        	tooltip :getCommonTranslation('DELETE')
        }],
        columns: [{
            header: getFeeAndPaymentCommonTranslation('DOCUMENT_NAME'),
            dataIndex: 'documentName',
            flex: 1
        }, {
            header: getFeeAndPaymentCommonTranslation('APPLICABILITY'),
            dataIndex: 'applicability',
            flex: 1,
            renderer: function(value) {
            	if(!isNullOrEmpty(value)) {
            		if(value == 'MANDATORY') {
            			return getCommonTranslation('MANDATORY');
            		}
            		if(value == 'OPTIONAL') {
            			return getCommonTranslation('OPTIONAL');
            		}
            	}
            }
        }, {
            header: getFeeAndPaymentCommonTranslation('APPLICABLE_TO'),
            dataIndex: 'applicableTo',
            flex: 1,
            renderer: function(value) {
            	if(!isNullOrEmpty(value)) {
            		if(value == 'APPLICANT') {
            			return getFeeAndPaymentCommonTranslation('APPLICANT');
            		}
            		if(value == 'STUDENT') {
            			return getFeeAndPaymentCommonTranslation('STUDENT');
            		}
            	}
            }
        }, {
            header: getFeeAndPaymentCommonTranslation('ALLOW_UPLOAD'),
            dataIndex: 'isAllowUplaod',
            flex: 1,
            renderer: function(value) {
            	if(!isNullOrEmpty(value)) {
            		if(value == 'true' || value == true) {
            			return getCommonTranslation('YES');
            		}
            		else {
            			return getCommonTranslation('NO');
            		}
            	}
            }
        }, {
            header: getFeeAndPaymentCommonTranslation('REMARKS'),
            dataIndex: 'remark',
            flex: 1
        }]
    }, {
		xtype:'fieldcontainer',
		style: {
			marginLeft:"10px !important"
		},
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SUBMIT'),
			ui: 'CustomBtnCancel',
			itemId: 'submitBtnItemId',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});