/**
 * @author priyanshi sharma
 */
Ext.define('Academia.view.securitysetup.MultipleALandRolesForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.multiplealandrolesform',
	frame: true,
	border:true,
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items:[{
            xtype:'panel',
            cls : 'panelNoSpace',
            width : 300,
            items:[{
    			xtype: 'multiselectcombofield',
    			name: 'multiAcademyLocation',
    			itemId: 'multiAcademyLocationId',
    			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
    			valueField: 'id',
    			displayField: 'value',
    			width : 300,
    			store: 'feeandpayment.AcademyLocationManageHoldMappingList',
    			labelAlign:'top',
    			cls:'multiBrandCampusCls',
    			typeAhead: true,
    			allowBlank:false,
    			forceSelection: true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			}
    		}]
		},{
    		xtype: 'datefield',
    		name: 'academyLocStartDate',
    		itemId:'academyLocStartDate',
    		vtype: 'daterange',
			endDateField: 'academyLocTillDate',
			editable:false,
			style:{
    			marginLeft:'10px !important'
    		},
    		fieldLabel:getCommonTranslation('START_DATE'),
    		allowBlank:false,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			},
    			select:function(field){
    				var roleStartDate = Ext.ComponentQuery.query('datefield#roleStartDate')[0];
    				roleStartDate.setMinValue(field.getValue());
    			}
    		},
    	},{
    		xtype: 'datefield',
    		name: 'academyLocTillDate',
    		itemId:'academyLocTillDate',
    		vtype: 'daterange',
    		startDateField: 'academyLocStartDate',
			editable:false,
			style:{
    			marginLeft:'1px !important'
    		},
    		fieldLabel:getCommonTranslation('TILL_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    	}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items:[{
            xtype:'panel',
            cls : 'panelNoSpace',
            width : 300,
            items:[{
            	xtype: 'multiselectcombofield',
            	name: 'multipleRoles',
            	itemId: 'multipleRolesId',
            	fieldLabel: getCommonTranslation('ROLE'),
            	valueField: 'id',
            	displayField: 'value',
            	width : 300,
            	store: 'securitysetup.ActiveLockedAndUnLockedRolesStore',
            	labelAlign:'top',
            	cls:'multiBrandCampusCls',
            	typeAhead: true,
            	allowBlank:false,
            	forceSelection: true,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}' +
            			'</div>';
            		}
            	}
            }]
		    },{
    		xtype: 'datefield',
    		name: 'roleStartDate',
    		itemId:'roleStartDate',
    		vtype: 'daterange',
			endDateField: 'roleTillDate',
			editable:false,
    		fieldLabel:getCommonTranslation('START_DATE'),
    		style:{
    			marginLeft:'10px !important'
    		},
    		allowBlank:false,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    	},{
    		xtype: 'datefield',
    		name: 'roleTillDate',
    		itemId:'roleTillDate',
    		vtype: 'daterange',
    		startDateField: 'roleStartDate',
			editable:false,
			style:{
    			marginLeft:'1px !important'
    		},
    		fieldLabel:getCommonTranslation('TILL_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		items:[{
			xtype: 'button',
			text: getCommonTranslation('GENERATE'),
			formBind: true,
			itemId: 'GenDataBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	},{
		xtype: 'multiplealandrolesgrid',
		itemId:'multiplealandrolesgrid',
		style: {marginLeft:'1px'},
		minHeight:200,
		maxHeight:400
	}]
});