Ext.define('Academia.view.securitysetup.RoleGrid',{
	//extend:'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.rolegrid',
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	//multiSelect:true,
	frame:false,
	//sortableColumns:true,
	//selType:'checkboxmodel',
//	selModel: Ext.create('Ext.selection.CheckboxModel', { 
//		showHeaderCheckbox: false 
//	}),
	selModel : {
		selType : 'checkboxmodel',
		checkOnly : 'true',
		allowDeselect : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'rolegridpanel':1
		}
	},
	border : true,
	store: 'securitysetup.Roles',
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'securitysetup.Roles',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns:[{
    	 header:getCommonTranslation('ROLE_ID'),
    	dataIndex:'serialNumber',
    	flex:1,
    	sortable:true
	},{
		header:getCommonTranslation('ROLE_NAME'),
		dataIndex:'roleNameTranslated',
		flex:1	
	},{
		header:'Created On',
		dataIndex:'createdOn',
		flex:1,
		 type:'Date',
		 renderer:function(date){   		  
			 return dateRender(date);
		 }
	},{
		header : getCommonTranslation('LOCK_UNLOCK_STATUS'),
		dataIndex : 'isLocked',
		flex:1,
		renderer: function (value) {
		    if(value == true){
		    	return  getCommonTranslation('GRID_FIELD_LOCKED');
		    }else{
		    	return  getCommonTranslation('GRID_FIELD_UNLOCKED');
		    }
		}
	}],
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip : getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip : getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        iconCls: 'view-icon'	,
        tooltip : getCommonTranslation('VIEW')
        //glyph: ICONGLYPH.VIEWGLYPH
    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip : getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH       
    },{
    	/*xtype:'textfield',
    	fieldLabel:getCommonTranslation('SEARCH'),
    	labelWidth: 50,
    	name:'searchRole',
    	itemId:'searchRoleId',
    	cls: 'SearchTextFieldWithSmallHeader'*/
    	xtype:'customcombobox',
		fieldLabel:getCommonTranslation('SEARCH'),
		name:'searchRole',
		itemId:'searchRoleId',
		store : 'securitysetup.ActiveRolesStore',
		valueField : 'id',
		displayField : 'value',
    	labelWidth: 50,
		//editable:false,
		forceSelection :true,
		//allowBlank:false,
		forceSelection :true,
		//queryParam:'roleName',
		minChars:3,
		typeAhead:false,
		hideTrigger:false,
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		triggerAction: '',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
    },{
    	xtype:'button',
    	itemId: 'btnSearch',
    	iconCls: 'search-icon',
        tooltip:'Search'
    },'',{
		xtype : 'splitbutton',				
		//glyph: ICONGLYPH.LISTGLYPH,
		itemId: 'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCommonTranslation('ROLE_COMPARE'),
			itemId:'btnCompareRole'
		},{
				text:getCommonTranslation('ROLE_COPY_CREATE'),
				itemId:'btnCopyCreateRole'
		},{
			text:getCommonTranslation('LOCK_USER_ROLE'),
			itemId:'lockUserRole',
			hidden:true
		},{
			text:getCommonTranslation('UNLOCK_USER_ROLE'),
			itemId:'UnlockUserRole',
			hidden:true
		}],listeners: { click: function() { this.showMenu(); } }
	},{
		xtype : 'button',
		text : getCommonTranslation('RESET'),
		//ui : 'CustomBtnCancel',
		name : 'resetBtnRoleGrid',
		itemId : 'resetBtnRoleGrid',
		scale : CONSTANTS.BUTTONSIZE
	}],
	
	 initComponent: function() {
		  var grid=this;     
		  var this$ = this;
		  grid.addExportToolBarItems(grid);
	        /*var store = this$.buildStore();
	        Ext.apply(this$, {
	            store: store,
	            bbar:[{
	            	xtype: 'custompagingtoolbar',
	                plugins:['pagesize'],
	            	store:store,
	            	emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
	            	itemId:'roleGridPagination',
	        	    displayInfo : true		 	
	            }]
	        });*/

	        this$.callParent(arguments);
	    },
	    buildStore: function() {
	        return Ext.create('Academia.store.securitysetup.Roles');
	    }
    
});